/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.parsers.SAXParserFactory;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.internal.xml.parser.DefaultXmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.internal.xml.parser.MuleDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlConfigurationDocumentLoader {
    private static final int VALIDATION_XSD = 3;
    private static final int NO_VALIDATION = 0;
    private final XmlGathererErrorHandlerFactory xmlGathererErrorHandlerFactory;
    private final int validationMode;

    public static XmlConfigurationDocumentLoader schemaValidatingDocumentLoader() {
        return new XmlConfigurationDocumentLoader(new DefaultXmlGathererErrorHandlerFactory());
    }

    public static XmlConfigurationDocumentLoader schemaValidatingDocumentLoader(XmlGathererErrorHandlerFactory errorHandlerFactory) {
        return new XmlConfigurationDocumentLoader(errorHandlerFactory);
    }

    public static XmlConfigurationDocumentLoader noValidationDocumentLoader() {
        return new XmlConfigurationDocumentLoader(null);
    }

    private XmlConfigurationDocumentLoader(XmlGathererErrorHandlerFactory errorHandlerFactory) {
        this.validationMode = errorHandlerFactory != null ? 3 : 0;
        this.xmlGathererErrorHandlerFactory = errorHandlerFactory;
    }

    public Document loadDocument(Supplier<SAXParserFactory> saxParserFactorySupplier, String filename, InputStream inputStream, EntityResolver entityResolver) {
        return this.loadDocument(saxParserFactorySupplier, entityResolver, filename, inputStream);
    }

    public Document loadDocument(Supplier<SAXParserFactory> saxParserFactorySupplier, EntityResolver entityResolver, String filename, InputStream inputStream) {
        return this.loadDocument(saxParserFactorySupplier, entityResolver, filename, inputStream, null);
    }

    public Document loadDocument(Supplier<SAXParserFactory> saxParserFactorySupplier, EntityResolver entityResolver, String filename, InputStream inputStream, XMLGrammarPool xmlGrammarPool) {
        Document document;
        XmlGathererErrorHandler errorHandler = this.createXmlGathererErrorHandler();
        try {
            document = new MuleDocumentLoader().loadDocument(saxParserFactorySupplier, new InputSource(inputStream), entityResolver, errorHandler == null ? new DefaultHandler() : errorHandler, this.validationMode, true, xmlGrammarPool);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Error loading: %s, %s", filename, e.getMessage())), (Throwable)e);
        }
        finally {
            this.closeQuietly(inputStream);
        }
        if (this.validationMode == 3) {
            this.throwExceptionIfErrorsWereFound(errorHandler, filename);
        }
        return document;
    }

    private void closeQuietly(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void throwExceptionIfErrorsWereFound(XmlGathererErrorHandler errorHandler, String filename) {
        List<SAXParseException> errors = errorHandler.getErrors();
        if (!errors.isEmpty()) {
            String subMessage = String.format(errors.size() == 1 ? "was '%s' error" : "were '%s' errors", errors.size());
            StringBuilder sb = new StringBuilder("There " + subMessage + " while parsing the given file" + (filename.isEmpty() ? "." : " '" + filename + "'."));
            sb.append(System.lineSeparator()).append("Full list:");
            errors.forEach(error -> sb.append(System.lineSeparator()).append(error));
            sb.append(System.lineSeparator());
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(sb.toString()));
        }
    }

    private XmlGathererErrorHandler createXmlGathererErrorHandler() {
        return this.validationMode == 3 ? this.xmlGathererErrorHandlerFactory.create() : null;
    }
}

