/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.classloader;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.core.api.util.ClassLoaderResourceNotFoundExceptionFactory;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.deployment.model.internal.artifact.CompositeClassLoaderArtifactFinder;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.classloader.ArtifactClassLoaderResourceNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.classloader.ClassLoaderNode;
import org.mule.runtime.module.deployment.impl.internal.classloader.DefaultClassLoaderNode;
import org.mule.runtime.module.deployment.impl.internal.classloader.MuleClassNotFoundException;

public class MuleClassLoaderResourceNotFoundExceptionFactory
implements ClassLoaderResourceNotFoundExceptionFactory {
    private static final String DOMAIN_CLASS_LOADER_ID = "Domain Class Loader";
    private static final String APP_CLASS_LOADER_ID = "App Class Loader";
    private static final String DOMAIN_REGION_CL_ID = "Domain Region CL";
    private static final String APP_REGION_CL_ID = "App Region CL";
    private static final String RUNTIME_CLASS_LOADER_ID = "Runtime Class Loader";
    public static final String PLUGIN_CL_ID_TEMPLATE = "%s Plugin CL";

    @Override
    public ResourceNotFoundException createResourceNotFoundException(String resourceName, ClassLoader classLoader, boolean triedAbsolutePath) {
        BiFunction<String, ClassLoaderNode, List<ClassLoaderNode>> findPossibleOwnersFunction = (resource, classLoaderNode) -> classLoaderNode.findPossibleResourceOwners(resourceName);
        Function<String, String> genericMsgProviderFunction = resource -> ClassLoaderResourceNotFoundExceptionFactory.getResourceNotFoundErrorMessage(resourceName, triedAbsolutePath);
        BiFunction<String, ClassLoader, ResourceNotFoundException> genericExceptionProviderFunction = (resource, classloader) -> ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory().createResourceNotFoundException(resourceName, classLoader, triedAbsolutePath);
        BiFunction<String, ClassLoaderNode, ResourceNotFoundException> detailedExceptionProviderFunction = (msg, classLoaderNode) -> new ArtifactClassLoaderResourceNotFoundException(I18nMessageFactory.createStaticMessage(msg), (ClassLoaderNode)classLoaderNode);
        return this.createNotFoundException(resourceName, "resource", "resource", classLoader, findPossibleOwnersFunction, genericMsgProviderFunction, genericExceptionProviderFunction, detailedExceptionProviderFunction);
    }

    @Override
    public ClassNotFoundException createClassNotFoundException(String className, ClassLoader classLoader) {
        BiFunction<String, ClassLoaderNode, List<ClassLoaderNode>> findPossibleOwnersFunction = (resource, classLoaderNode) -> classLoaderNode.findPossibleClassOwners(className);
        Function<String, String> genericMsgProviderFunction = resource -> ClassLoaderResourceNotFoundExceptionFactory.getClassNotFoundErrorMessage(className);
        BiFunction<String, ClassLoader, ClassNotFoundException> genericExceptionProviderFunction = (resource, classloader) -> ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory().createClassNotFoundException(className, classLoader);
        BiFunction<String, ClassLoaderNode, ClassNotFoundException> detailedExceptionProviderFunction = (msg, classLoaderNode) -> new MuleClassNotFoundException((String)msg, (ClassLoaderNode)classLoaderNode);
        return this.createNotFoundException(className, "class", "package where the class", classLoader, findPossibleOwnersFunction, genericMsgProviderFunction, genericExceptionProviderFunction, detailedExceptionProviderFunction);
    }

    private <T> T createNotFoundException(String resource, String resourceType, String exportMsg, ClassLoader classLoader, BiFunction<String, ClassLoaderNode, List<ClassLoaderNode>> findPossibleOwnersFunction, Function<String, String> genericMsgProviderFunction, BiFunction<String, ClassLoader, T> genericExceptionProviderFunction, BiFunction<String, ClassLoaderNode, T> detailedExceptionProviderFunction) {
        ClassLoader contextClassLoader = classLoader;
        if (contextClassLoader instanceof CompositeClassLoader) {
            contextClassLoader = CompositeClassLoaderArtifactFinder.findClassLoader((CompositeClassLoader)contextClassLoader);
        }
        String moduleLayerInfo = MuleClassLoaderResourceNotFoundExceptionFactory.getModuleLayerInfo(contextClassLoader).map(info -> System.lineSeparator() + "Module Layer Information:" + System.lineSeparator() + info).orElse("");
        if (contextClassLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)contextClassLoader);
            ClassLoaderNode classLoaderNode = this.createClassLoaderNode(artifactClassLoader);
            ClassLoaderNode currentContextClassLoaderNode = classLoaderNode.findClassLoaderNode(artifactClassLoader);
            List<ClassLoaderNode> possibleResourceOwners = findPossibleOwnersFunction.apply(resource, classLoaderNode);
            String possibleResourceOwnersMessage = possibleResourceOwners.isEmpty() ? String.format("Seems the %s doesn't exist in any classloader. Verify you wrote the right %s name.", resourceType, resourceType) : String.format("The %s exists in the following context (%s) but is not exported. Try exporting the %s by modifying the mule-artifact.json file", resourceType, String.join((CharSequence)",", possibleResourceOwners.stream().map(cln -> cln.getId()).collect(Collectors.toList())), exportMsg);
            return detailedExceptionProviderFunction.apply(String.format("%s " + System.lineSeparator() + " %s " + System.lineSeparator() + " %s " + System.lineSeparator() + " %s%s", genericMsgProviderFunction.apply(resource), classLoaderNode, String.format("Current classloader in context is (%s)", currentContextClassLoaderNode.getId()), possibleResourceOwnersMessage, moduleLayerInfo), classLoaderNode);
        }
        return genericExceptionProviderFunction.apply(resource, classLoader);
    }

    private ClassLoaderNode createClassLoaderNode(ArtifactClassLoader artifactClassLoader) {
        ArtifactClassLoader artifactClassLoader2 = artifactClassLoader = artifactClassLoader instanceof RegionClassLoader ? ((RegionClassLoader)artifactClassLoader).getOwnerClassLoader() : artifactClassLoader;
        if (artifactClassLoader instanceof MuleApplicationClassLoader) {
            return this.createFromApplicationClassLoader((MuleApplicationClassLoader)artifactClassLoader);
        }
        if (artifactClassLoader instanceof MuleSharedDomainClassLoader) {
            return this.createFromDomainClassLoaderNode((MuleSharedDomainClassLoader)artifactClassLoader);
        }
        if (artifactClassLoader instanceof FilteringContainerClassLoader) {
            return this.createFromRuntimeClassLoader(artifactClassLoader);
        }
        return this.createFromPluginClassLoaderNode(artifactClassLoader);
    }

    private DefaultClassLoaderNode createFromRuntimeClassLoader(ArtifactClassLoader artifactClassLoader) {
        return DefaultClassLoaderNode.builder().withId(RUNTIME_CLASS_LOADER_ID).withArtifactClassLoader(artifactClassLoader).build();
    }

    private ClassLoaderNode createFromPluginClassLoaderNode(ArtifactClassLoader artifactClassLoader) {
        ArtifactClassLoader ownerClassLoader = ((RegionClassLoader)artifactClassLoader.getClassLoader().getParent()).getOwnerClassLoader();
        if (ownerClassLoader.getArtifactDescriptor() instanceof ApplicationDescriptor) {
            return this.createFromApplicationClassLoader((MuleApplicationClassLoader)ownerClassLoader);
        }
        return this.createFromDomainClassLoaderNode((MuleSharedDomainClassLoader)ownerClassLoader);
    }

    private ClassLoaderNode createRegionClassLoaderNode(RegionClassLoader regionClassLoader, ClassLoaderNode ownerClassLoaderNode) {
        boolean isDomainRegionClassLoader = ownerClassLoaderNode.getArtifactClassLoader() instanceof MuleSharedDomainClassLoader;
        return DefaultClassLoaderNode.builder().withArtifactClassLoader(regionClassLoader).withParent(this.createClassLoaderNode((ArtifactClassLoader)((Object)regionClassLoader.getParent()))).withId(isDomainRegionClassLoader ? DOMAIN_REGION_CL_ID : APP_REGION_CL_ID).withDelegateNodes((List<ClassLoaderNode>)ImmutableList.builder().addAll((Iterable)regionClassLoader.getArtifactPluginClassLoaders().stream().map(this.toPluginClassLoaderNode()).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableList())).add((Object)ownerClassLoaderNode).build()).build();
    }

    private Function<ArtifactClassLoader, ClassLoaderNode> toPluginClassLoaderNode() {
        return pluginClassLoader -> DefaultClassLoaderNode.builder().withArtifactClassLoader((ArtifactClassLoader)pluginClassLoader).withIsMulePlugin(true).withId(String.format(PLUGIN_CL_ID_TEMPLATE, ((ArtifactDescriptor)pluginClassLoader.getArtifactDescriptor()).getName())).build();
    }

    private ClassLoaderNode createFromApplicationClassLoader(MuleApplicationClassLoader muleApplicationClassLoader) {
        return this.createRegionClassLoaderNode((RegionClassLoader)muleApplicationClassLoader.getParent(), DefaultClassLoaderNode.builder().withArtifactClassLoader(muleApplicationClassLoader).withId(APP_CLASS_LOADER_ID).build());
    }

    private ClassLoaderNode createFromDomainClassLoaderNode(MuleSharedDomainClassLoader domainArtifactClassLoader) {
        if (domainArtifactClassLoader.getParent() instanceof RegionClassLoader) {
            return this.createRegionClassLoaderNode((RegionClassLoader)domainArtifactClassLoader.getParent(), DefaultClassLoaderNode.builder().withArtifactClassLoader(domainArtifactClassLoader).withId(DOMAIN_CLASS_LOADER_ID).build());
        }
        return DefaultClassLoaderNode.builder().withArtifactClassLoader(domainArtifactClassLoader).withId(DOMAIN_CLASS_LOADER_ID).withParent(this.createClassLoaderNode((ArtifactClassLoader)((Object)domainArtifactClassLoader.getParent()))).build();
    }

    public static Optional<String> getModuleLayerInfo(ClassLoader classLoader) {
        if (classLoader == null) {
            return Optional.empty();
        }
        if (classLoader instanceof ArtifactClassLoader) {
            Optional<String> info = ((ArtifactClassLoader)((Object)classLoader)).getModuleLayerInformation().map(ModuleLayerInformationSupplier::retrieveRepresentation);
            return info.isPresent() ? info : MuleClassLoaderResourceNotFoundExceptionFactory.getModuleLayerInfo(classLoader.getParent());
        }
        return MuleClassLoaderResourceNotFoundExceptionFactory.getModuleLayerInfo(classLoader.getParent());
    }
}

