/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowListener
implements FlowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFlowListener.class);
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private Consumer<Message> successConsumer;
    private Consumer<Exception> errorConsumer;
    private Runnable onComplete;

    public DefaultFlowListener(ExtensionModel extensionModel, OperationModel operationModel, CoreEvent event) {
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        BaseEventContext context = (BaseEventContext)event.getContext();
        context.onResponse(this::onResponse);
        context.getRootContext().onTerminated((e, t) -> this.onTerminated());
    }

    @Override
    public void onSuccess(Consumer<Message> handler) {
        this.assertNotNull(handler);
        this.successConsumer = handler;
    }

    @Override
    public void onError(Consumer<Exception> handler) {
        this.assertNotNull(handler);
        this.errorConsumer = handler;
    }

    @Override
    public void onComplete(Runnable handler) {
        this.assertNotNull(handler);
        this.onComplete = handler;
    }

    private void onResponse(CoreEvent event, Throwable error) {
        if (event != null && this.successConsumer != null) {
            try {
                this.successConsumer.accept(event.getMessage());
            }
            catch (Exception e) {
                LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onSuccess FlowListener", (Throwable)e);
            }
        } else if (error != null && this.errorConsumer != null) {
            Exception exception = error instanceof Exception ? (Exception)error : new MessagingException(event, error);
            try {
                this.errorConsumer.accept(exception);
            }
            catch (Exception e) {
                LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onError FlowListener", (Throwable)e);
            }
        }
    }

    private void onTerminated() {
        if (this.onComplete != null) {
            try {
                this.onComplete.run();
            }
            catch (Exception e) {
                LOGGER.warn("Operation " + this.operationModel.getName() + " from extension " + this.extensionModel.getName() + " threw exception while executing the onComplete FlowListener", (Throwable)e);
            }
        }
    }

    private void assertNotNull(Object handler) {
        Preconditions.checkArgument(handler != null, "Cannot set null handler");
    }
}

