/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.graph.SynchronizedTransformationGraph;
import org.mule.runtime.core.internal.transformer.graph.TransformationEdge;
import org.mule.runtime.core.privileged.transformer.CompositeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationGraphLookupStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SynchronizedTransformationGraph graph;

    public TransformationGraphLookupStrategy(SynchronizedTransformationGraph graph) {
        this.graph = graph;
    }

    public List<Converter> lookupConverters(DataType source, DataType target) {
        List<Converter> converters = new LinkedList<Converter>();
        if (!this.graph.containsVertexOrSuper(source)) {
            return converters;
        }
        if (!this.graph.containsVertexOrSub(target)) {
            return converters;
        }
        List<DataType> compatibleSourceVertexes = this.graph.getSuperVertexes(source);
        List<DataType> compatibleTargetVertexes = this.graph.getSubVertexes(target);
        LinkedList<List<TransformationEdge>> transformationPaths = new LinkedList<List<TransformationEdge>>();
        for (DataType sourceVertex : compatibleSourceVertexes) {
            for (DataType targetVertex : compatibleTargetVertexes) {
                transformationPaths.addAll(this.findTransformationPaths(sourceVertex, targetVertex, new HashSet<DataType>()));
            }
        }
        converters = this.createConverters(transformationPaths);
        return converters;
    }

    private List<Converter> createConverters(List<List<TransformationEdge>> transformationPaths) {
        HashSet<CompositeConverter> converters = new HashSet<CompositeConverter>();
        for (List<TransformationEdge> transformationPath : transformationPaths) {
            Converter[] pathConverters = new Converter[transformationPath.size()];
            int index = 0;
            for (TransformationEdge edge : transformationPath) {
                pathConverters[index++] = edge.getConverter();
            }
            Converter converter = transformationPath.size() == 1 ? transformationPath.get(0).getConverter() : new CompositeConverter(pathConverters);
            converters.add((CompositeConverter)converter);
        }
        return new ArrayList<Converter>(converters);
    }

    private List<List<TransformationEdge>> findTransformationPaths(DataType source, DataType target, Set<DataType> visited) {
        LinkedList<List<TransformationEdge>> validTransformationEdges = new LinkedList<List<TransformationEdge>>();
        if (visited.contains(source)) {
            return validTransformationEdges;
        }
        visited.add(source);
        Set<TransformationEdge> transformationEdges = this.graph.outgoingEdgesOf(source);
        for (TransformationEdge transformationEdge : transformationEdges) {
            DataType edgeTarget = this.graph.getEdgeTarget(transformationEdge);
            if (target.isCompatibleWith(edgeTarget)) {
                LinkedList<TransformationEdge> transformationEdges1 = new LinkedList<TransformationEdge>();
                transformationEdges1.add(transformationEdge);
                validTransformationEdges.add(transformationEdges1);
                continue;
            }
            List<List<TransformationEdge>> newTransformations = this.findTransformationPaths(edgeTarget, target, visited);
            for (List<TransformationEdge> transformationEdgeList : newTransformations) {
                transformationEdgeList.add(0, transformationEdge);
                validTransformationEdges.add(transformationEdgeList);
            }
        }
        visited.remove(source);
        return validTransformationEdges;
    }
}

