/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigModelLoaderDelegate.class);

    ConfigModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declarer, ExtensionModelParser extensionModelParser) {
        for (ConfigurationModelParser configParser : extensionModelParser.getConfigurationParsers()) {
            String configName = this.resolveConfigName(configParser);
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(configName).describedAs(this.resolveConfigDescription(configParser, configName)).withModelProperty(configParser.getConfigurationFactoryModelProperty());
            if (configParser.isForceNoImplicit()) {
                configurationDeclarer.withModelProperty(new NoImplicitModelProperty());
            }
            configParser.getDeprecationModel().ifPresent(dm -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).withDeprecation((DeprecationModel)dm));
            configParser.getDisplayModel().ifPresent(d -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).setDisplayModel((DisplayModel)d));
            configParser.getExternalLibraryModels().forEach(configurationDeclarer::withExternalLibrary);
            configParser.getAdditionalModelProperties().forEach(configurationDeclarer::withModelProperty);
            configParser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> {
                configurationDeclarer.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
                LOGGER.debug(resolvedMMV.getReason());
            });
            this.loader.getParameterModelsLoaderDelegate().declare(configurationDeclarer, configParser.getParameterGroupParsers());
            this.getOperationLoaderDelegate().declareOperations(declarer, extensionModelParser.getDevelopmentFramework(), configurationDeclarer, configParser.getOperationParsers());
            this.getSourceModelLoaderDelegate().declareMessageSources(declarer, configurationDeclarer, configParser.getSourceModelParsers());
            this.getFunctionModelLoaderDelegate().declareFunctions(declarer, configParser.getFunctionModelParsers());
            this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders(configurationDeclarer, configParser.getConnectionProviderModelParsers());
            this.getStereotypeModelLoaderDelegate().addStereotypes(configParser, configurationDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultConfigStereotype(configParser.getName())));
        }
    }

    private String resolveConfigName(ConfigurationModelParser parser) {
        return StringUtils.isBlank(parser.getName()) ? "config" : parser.getName();
    }

    private String resolveConfigDescription(ConfigurationModelParser parser, String configName) {
        String description = parser.getDescription();
        if (StringUtils.isBlank(description) && "config".equals(configName)) {
            description = "Default configuration";
        }
        return description;
    }
}

