/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.error.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.info.ExtensionInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.soap.internal.loader.SoapExtensionTypeFactory;
import org.mule.runtime.module.extension.soap.internal.loader.SoapInvokeOperationDeclarer;
import org.mule.runtime.module.extension.soap.internal.loader.SoapServiceProviderDeclarer;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.MessageDispatcherProviderTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapExtensionTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;
import org.mule.runtime.soap.api.exception.error.SoapErrors;

public final class SoapModelLoaderDelegate
implements ModelLoaderDelegate {
    private final Class<?> extensionType;
    private final ExtensionElement extensionElement;
    private final String version;
    private final ClassTypeLoader typeLoader;
    private SoapServiceProviderDeclarer serviceProviderDeclarer;
    private SoapInvokeOperationDeclarer operationDeclarer;
    private StereotypeModelLoaderDelegate stereotypeDelegate;

    public SoapModelLoaderDelegate(ExtensionElement extensionElement, String version) {
        this.extensionType = extensionElement.getDeclaringClass().get();
        this.extensionElement = extensionElement;
        this.version = version;
        this.typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader(this.extensionType.getClassLoader());
    }

    @Override
    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        JavaExtensionModelParser parser = new JavaExtensionModelParser(this.extensionElement, context);
        ExtensionDeclarer extensionDeclarer = this.getExtensionDeclarer(context);
        XmlDslModel xmlDslModel = ModelLoaderUtils.getXmlDslModel(this.extensionElement, this.version, parser.getXmlDslConfiguration());
        extensionDeclarer.withXmlDsl(xmlDslModel);
        this.stereotypeDelegate = new StereotypeModelLoaderDelegate(context);
        this.stereotypeDelegate.setNamespace(ExtensionNamespaceUtils.getExtensionsNamespace(xmlDslModel));
        this.operationDeclarer = new SoapInvokeOperationDeclarer(this.stereotypeDelegate);
        this.serviceProviderDeclarer = new SoapServiceProviderDeclarer(extensionDeclarer, parser::getStereotypeLoaderDelegate, this.stereotypeDelegate);
        SoapExtensionTypeWrapper extension = SoapExtensionTypeFactory.getSoapExtensionType(this.extensionType, this.typeLoader);
        List<MessageDispatcherProviderTypeWrapper> customTransportProviders = extension.getDispatcherProviders();
        this.declareSubtypes(extensionDeclarer, customTransportProviders);
        Set<ErrorModel> soapErrors = this.getSoapErrors(extensionDeclarer);
        soapErrors.forEach(extensionDeclarer::withErrorModel);
        ConfigurationDeclarer configDeclarer = this.getConfigDeclarer(extensionDeclarer, extension, soapErrors);
        extension.getSoapServiceProviders().forEach(provider -> this.serviceProviderDeclarer.declare(configDeclarer, (SoapServiceProviderWrapper)provider, !customTransportProviders.isEmpty()));
        return extensionDeclarer;
    }

    private void declareSubtypes(ExtensionDeclarer extension, List<MessageDispatcherProviderTypeWrapper> transportProviders) {
        if (!transportProviders.isEmpty()) {
            List<MetadataType> types = transportProviders.stream().map(TypeWrapper::asMetadataType).collect(Collectors.toList());
            extension.withSubTypes(this.typeLoader.load((Type)((Object)MessageDispatcherProvider.class)), types);
        }
    }

    private ExtensionDeclarer getExtensionDeclarer(ExtensionLoadingContext context) {
        ExtensionInfo info = MuleExtensionAnnotationParser.getExtensionInfo(this.extensionType);
        return context.getExtensionDeclarer().named(info.getName()).onVersion(this.version).fromVendor(info.getVendor()).withCategory(info.getCategory()).withModelProperty(new SoapExtensionModelProperty()).withModelProperty(new ExtensionTypeDescriptorModelProperty(new TypeWrapper(this.extensionType, this.typeLoader))).withModelProperty(new ImplementingTypeModelProperty(this.extensionType));
    }

    private ConfigurationDeclarer getConfigDeclarer(ExtensionDeclarer declarer, SoapExtensionTypeWrapper<?> extension, Set<ErrorModel> soapErrors) {
        Class<?> clazz = extension.getDeclaringClass().get();
        TypeAwareConfigurationFactory configurationFactory = new TypeAwareConfigurationFactory(clazz, clazz.getClassLoader());
        ConfigurationDeclarer configDeclarer = declarer.withConfig("config").describedAs("Default configuration").withStereotype(this.stereotypeDelegate.getDefaultConfigStereotype("config")).withModelProperty(new ConfigurationFactoryModelProperty(configurationFactory)).withModelProperty(new ImplementingTypeModelProperty(clazz));
        this.operationDeclarer.declare(configDeclarer, this.typeLoader, soapErrors);
        return configDeclarer;
    }

    private Set<ErrorModel> getSoapErrors(ExtensionDeclarer declarer) {
        ErrorsModelFactory factory = new ErrorsModelFactory((ErrorTypeDefinition[])SoapErrors.class.getEnumConstants(), ((ExtensionDeclaration)declarer.getDeclaration()).getName());
        return factory.getErrorModels();
    }
}

