/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import com.google.common.hash.Hashing;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.ParameterModelComparator;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.runtime.module.extension.internal.capability.xml.DocumenterUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.CollectionSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ConfigurationSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ConnectionProviderSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.MapSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ObjectTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.OperationSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SourceSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Annotation;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Attribute;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Documentation;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.FormChoice;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Import;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalSimpleType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.NamedGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.NoFixedFacet;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Restriction;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Schema;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.SchemaTypeConversion;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelSimpleType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.Union;
import org.mule.runtime.module.extension.internal.config.dsl.SchemaConstants;

public final class SchemaBuilder {
    public String EE_SCHEMA_LOCATION = String.format("%s/%s/%s.xsd", DslConstants.EE_NAMESPACE, "current", "ee");
    private static final String GLOBAL_ABSTRACT_ELEMENT_MASK = "global-%s";
    private static final String AUTOGENERATED_TYPEID_MASK = "AUTOGENERATED_%s_";
    private final Set<StringType> registeredEnums = new LinkedHashSet<StringType>();
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final MetadataType OBJECT_STORE_TYPE = this.typeLoader.load((Type)((Object)ObjectStore.class));
    private final MetadataType STRING_TYPE = this.typeLoader.load((Type)((Object)String.class));
    private Schema schema;
    private boolean requiresTls = false;
    private ExtensionModel extensionModel;
    private DslSyntaxResolver dslResolver;
    private Set<ImportedTypeModel> importedTypes;
    private TypeCatalog typesMapping;
    private DslResolvingContext dslContext;
    private ConfigurationSchemaDelegate configurationSchemaDelegate;
    private ConnectionProviderSchemaDelegate connectionProviderSchemaDelegate;
    private OperationSchemaDelegate operationSchemaDelegate;
    private SourceSchemaDelegate sourceSchemaDelegate;
    private CollectionSchemaDelegate collectionDelegate;
    private ObjectTypeSchemaDelegate objectTypeDelegate;
    private MapSchemaDelegate mapDelegate;

    public static SchemaBuilder newSchema(ExtensionModel extensionModel, XmlDslModel xmlDslModel, DslResolvingContext dslContext) {
        SchemaBuilder builder = new SchemaBuilder();
        builder.extensionModel = extensionModel;
        builder.schema = new Schema();
        builder.schema.setTargetNamespace(xmlDslModel.getNamespace());
        builder.schema.setElementFormDefault(FormChoice.QUALIFIED);
        builder.schema.setAttributeFormDefault(FormChoice.UNQUALIFIED);
        builder.withDslSyntaxResolver(extensionModel, dslContext).importXmlNamespace().importMuleNamespace();
        builder.initialiseDelegates();
        builder.withImportedTypes(extensionModel.getImportedTypes());
        builder.withTypeMapping(extensionModel);
        builder.withTypes(extensionModel.getTypes());
        return builder;
    }

    private void initialiseDelegates() {
        this.configurationSchemaDelegate = new ConfigurationSchemaDelegate(this);
        this.connectionProviderSchemaDelegate = new ConnectionProviderSchemaDelegate(this);
        this.operationSchemaDelegate = new OperationSchemaDelegate(this);
        this.sourceSchemaDelegate = new SourceSchemaDelegate(this);
        this.collectionDelegate = new CollectionSchemaDelegate(this);
        this.objectTypeDelegate = new ObjectTypeSchemaDelegate(this);
        this.mapDelegate = new MapSchemaDelegate(this, this.typeLoader);
    }

    private SchemaBuilder withDslSyntaxResolver(ExtensionModel model, DslResolvingContext dslContext) {
        this.dslContext = dslContext;
        this.dslResolver = DslSyntaxResolver.getDefault(model, dslContext);
        return this;
    }

    private SchemaBuilder withTypeMapping(ExtensionModel model) {
        this.typesMapping = TypeCatalog.getDefault(Collections.singleton(model));
        model.getSubTypes().forEach(this.objectTypeDelegate::registerPojoSubtypes);
        return this;
    }

    private SchemaBuilder withImportedTypes(Set<ImportedTypeModel> importedTypes) {
        this.importedTypes = importedTypes;
        importedTypes.forEach(type -> this.dslContext.getExtensionForType(this.getTypeId(type.getImportedType())).ifPresent(this::registerExtensionImport));
        return this;
    }

    private SchemaBuilder withTypes(Collection<ObjectType> types) {
        types.stream().filter(t -> {
            Optional<DslElementSyntax> typeDsl = this.dslResolver.resolve((MetadataType)t);
            return typeDsl.isPresent() && typeDsl.get().supportsTopLevelDeclaration() || ExtensionMetadataTypeUtils.getSubstitutionGroup(t).isPresent();
        }).forEach(t -> this.objectTypeDelegate.registerPojoType((MetadataType)t, t.getDescription().orElse("")));
        return this;
    }

    DslSyntaxResolver getDslResolver() {
        return this.dslResolver;
    }

    public Schema build() {
        return this.schema;
    }

    private SchemaBuilder importXmlNamespace() {
        Import xmlImport = new Import();
        xmlImport.setNamespace("http://www.w3.org/XML/1998/namespace");
        this.schema.getIncludeOrImportOrRedefine().add(xmlImport);
        return this;
    }

    private Import createMuleImport() {
        Import muleSchemaImport = new Import();
        muleSchemaImport.setNamespace(DslConstants.CORE_NAMESPACE);
        muleSchemaImport.setSchemaLocation(DslConstants.CORE_SCHEMA_LOCATION);
        return muleSchemaImport;
    }

    private SchemaBuilder importMuleNamespace() {
        Import muleSchemaImport = this.createMuleImport();
        this.schema.getIncludeOrImportOrRedefine().add(muleSchemaImport);
        return this;
    }

    private Import createMuleEEImport() {
        Import muleSchemaImport = new Import();
        muleSchemaImport.setNamespace(DslConstants.EE_NAMESPACE);
        muleSchemaImport.setSchemaLocation(this.EE_SCHEMA_LOCATION);
        return muleSchemaImport;
    }

    private void importIfNotImported(Import newImport) {
        if (!this.schema.getIncludeOrImportOrRedefine().contains(newImport)) {
            this.schema.getIncludeOrImportOrRedefine().add(newImport);
        }
    }

    private SchemaBuilder importTlsNamespace() {
        Import tlsImport = new Import();
        tlsImport.setNamespace(SchemaConstants.MULE_TLS_NAMESPACE);
        tlsImport.setSchemaLocation("http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
        this.schema.getIncludeOrImportOrRedefine().add(tlsImport);
        return this;
    }

    public SchemaBuilder registerConnectionProviderElement(ConnectionProviderModel providerModel) {
        this.connectionProviderSchemaDelegate.registerConnectionProviderElement(providerModel, this.dslResolver.resolve(providerModel));
        return this;
    }

    public SchemaBuilder registerConfigElement(ConfigurationModel configurationModel) {
        this.configurationSchemaDelegate.registerConfigElement(this.schema, configurationModel, this.dslResolver.resolve(configurationModel));
        return this;
    }

    public SchemaBuilder registerOperation(ComponentModel operationModel) {
        this.operationSchemaDelegate.registerOperation(operationModel, this.dslResolver.resolve(operationModel), ExtensionModelUtils.componentHasAnImplicitConfiguration(this.extensionModel, operationModel));
        return this;
    }

    public SchemaBuilder registerMessageSource(SourceModel sourceModel) {
        this.sourceSchemaDelegate.registerMessageSource(sourceModel, this.dslResolver.resolve(sourceModel), ExtensionModelUtils.componentHasAnImplicitConfiguration(this.extensionModel, sourceModel));
        return this;
    }

    List<TopLevelElement> registerParameters(ExtensionType type, Collection<ParameterModel> parameterModels) {
        ArrayList<TopLevelElement> all = new ArrayList<TopLevelElement>(parameterModels.size());
        this.getSortedParameterModels(parameterModels).stream().filter(p -> !p.getModelProperty(QNameModelProperty.class).isPresent()).forEach(parameterModel -> {
            DslElementSyntax paramDsl = this.dslResolver.resolve((ParameterModel)parameterModel);
            this.declareAsParameter(parameterModel.getType(), type, (ParameterModel)parameterModel, paramDsl, (List<TopLevelElement>)all);
        });
        return all;
    }

    private List<ParameterModel> getSortedParameterModels(Collection<ParameterModel> parameterModels) {
        ArrayList<ParameterModel> sortedParameters = new ArrayList<ParameterModel>(parameterModels);
        sortedParameters.sort(new ParameterModelComparator(true));
        return sortedParameters;
    }

    public SchemaBuilder registerEnums() {
        this.registeredEnums.forEach(enumType -> this.registerEnum(this.schema, (StringType)enumType));
        return this;
    }

    private void registerEnum(Schema schema, StringType enumType) {
        EnumAnnotation enumAnnotation = enumType.getAnnotation(EnumAnnotation.class).orElseThrow(() -> new IllegalArgumentException("Cannot obtain enum values for the given type"));
        TopLevelSimpleType enumSimpleType = new TopLevelSimpleType();
        Optional<String> enumTypeId = this.getOrCreateEnumTypeId(enumType);
        enumSimpleType.setName(NameUtils.sanitizeName(enumTypeId) + "EnumType");
        Union union = new Union();
        union.getSimpleType().add(this.createEnumSimpleType(enumAnnotation));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        enumSimpleType.setUnion(union);
        schema.getSimpleTypeOrComplexTypeOrGroup().add(enumSimpleType);
    }

    private LocalSimpleType createExpressionAndPropertyPlaceHolderSimpleType() {
        LocalSimpleType expression = new LocalSimpleType();
        Restriction restriction = new Restriction();
        expression.setRestriction(restriction);
        restriction.setBase(SchemaConstants.MULE_PROPERTY_PLACEHOLDER_TYPE);
        return expression;
    }

    private LocalSimpleType createEnumSimpleType(EnumAnnotation<String> enumAnnotation) {
        LocalSimpleType enumValues = new LocalSimpleType();
        Restriction restriction = new Restriction();
        enumValues.setRestriction(restriction);
        restriction.setBase(SchemaConstants.STRING);
        for (String value : enumAnnotation.getValues()) {
            NoFixedFacet noFixedFacet = this.objectFactory.createNoFixedFacet();
            noFixedFacet.setValue(value);
            JAXBElement<NoFixedFacet> enumeration = this.objectFactory.createEnumeration(noFixedFacet);
            enumValues.getRestriction().getFacets().add(enumeration);
        }
        return enumValues;
    }

    private Optional<String> getOrCreateEnumTypeId(StringType enumType) {
        EnumAnnotation enumAnnotation = enumType.getAnnotation(EnumAnnotation.class).get();
        return ExtensionMetadataTypeUtils.getId(enumType).map(name -> name == String.class.getName() ? String.format(AUTOGENERATED_TYPEID_MASK, Hashing.sha256().hashString((CharSequence)String.join((CharSequence)".", Arrays.stream((String[])enumAnnotation.getValues()).collect(Collectors.toList())), StandardCharsets.UTF_8)) : name);
    }

    Attribute createAttribute(String name, MetadataType type, boolean required, ExpressionSupport expressionSupport) {
        return this.createAttribute(name, "", type, null, required, expressionSupport);
    }

    private Attribute createAttribute(final String name, String description, final MetadataType type, Object defaultValue, boolean required, final ExpressionSupport expressionSupport) {
        final Attribute attribute = new Attribute();
        attribute.setUse(required ? "required" : "optional");
        attribute.setAnnotation(this.createDocAnnotation(description));
        if (defaultValue instanceof String && StringUtils.isNotBlank((CharSequence)defaultValue.toString()) || defaultValue instanceof Enum) {
            attribute.setDefault(defaultValue.toString());
        }
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitString(StringType stringType) {
                Optional<EnumAnnotation> enumAnnotation = stringType.getAnnotation(EnumAnnotation.class);
                if (enumAnnotation.isPresent()) {
                    this.visitEnum(stringType);
                } else {
                    this.defaultVisit(stringType);
                }
            }

            private void visitEnum(StringType enumType) {
                attribute.setName(name);
                String typeName = (String)SchemaBuilder.this.getOrCreateEnumTypeId(enumType).get();
                if (DocumenterUtils.isOperationTransactionalActionType(typeName)) {
                    attribute.setType(SchemaConstants.MULE_OPERATION_TRANSACTIONAL_ACTION_TYPE);
                } else if (TransactionType.class.getName().equals(typeName)) {
                    attribute.setType(SchemaConstants.MULE_TRANSACTION_TYPE);
                    attribute.setDefault(TransactionType.LOCAL.name());
                } else {
                    attribute.setType(new QName(SchemaBuilder.this.schema.getTargetNamespace(), NameUtils.sanitizeName(typeName) + "EnumType"));
                    SchemaBuilder.this.registeredEnums.add(enumType);
                }
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                attribute.setName(name);
                attribute.setType(SchemaTypeConversion.convertType(type, expressionSupport));
            }
        });
        return attribute;
    }

    Attribute createValueAttribute(MetadataType genericType) {
        return this.createAttribute("value", genericType, true, ExpressionSupport.SUPPORTED);
    }

    ExplicitGroup createTypeRefChoiceLocalOrGlobal(DslElementSyntax typeDsl, MetadataType type, BigInteger minOccurs, String maxOccurs) {
        if (!this.isImported(type) && !this.OBJECT_STORE_TYPE.equals(type)) {
            this.objectTypeDelegate.registerPojoType(type, "");
            this.objectTypeDelegate.registerAbstractElement(type, typeDsl);
            if (typeDsl.supportsTopLevelDeclaration() || typeDsl.supportsChildDeclaration() && typeDsl.isWrapped()) {
                this.objectTypeDelegate.registerConcreteGlobalElement(typeDsl, "", ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), this.objectTypeDelegate.getTypeQName(typeDsl, type));
            }
        }
        ExplicitGroup choice = new ExplicitGroup();
        choice.setMinOccurs(minOccurs);
        choice.setMaxOccurs(maxOccurs);
        LinkedList<String> options = new LinkedList<String>();
        if (type.equals(this.OBJECT_STORE_TYPE)) {
            QName refInternal = SchemaConstants.PRIVATE_OBJECT_STORE_ELEMENT;
            TopLevelElement internalAbstractElementRef = this.createRefElement(refInternal, true);
            choice.getParticle().add(this.objectFactory.createElement(internalAbstractElementRef));
            options.add(refInternal.toString());
        } else {
            QName refAbstract = new QName(typeDsl.getNamespace(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), typeDsl.getPrefix());
            TopLevelElement localAbstractElementRef = this.createRefElement(refAbstract, true);
            choice.getParticle().add(this.objectFactory.createElement(localAbstractElementRef));
            options.add(refAbstract.toString());
            QName refGlobal = new QName(typeDsl.getNamespace(), String.format(GLOBAL_ABSTRACT_ELEMENT_MASK, ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl)), typeDsl.getPrefix());
            TopLevelElement topLevelElementRef = this.createRefElement(refGlobal, true);
            choice.getParticle().add(this.objectFactory.createElement(topLevelElementRef));
            options.add(refGlobal.toString());
        }
        this.typesMapping.getSubTypes((ObjectType)type).stream().filter(subtype -> this.dslResolver.resolve((MetadataType)subtype).map(DslElementSyntax::supportsChildDeclaration).orElse(false)).map(ExtensionMetadataTypeUtils::getSubstitutionGroup).filter(Optional::isPresent).map(Optional::get).forEach(customGroup -> {
            QName qName = this.resolveSubstitutionGroup((SubstitutionGroup)customGroup);
            if (!options.contains(qName.toString())) {
                TopLevelElement customGroupRef = this.createRefElement(qName, true);
                choice.getParticle().add(this.objectFactory.createElement(customGroupRef));
                options.add(customGroupRef.toString());
            }
        });
        return choice;
    }

    boolean isImported(MetadataType type) {
        return this.importedTypes.stream().anyMatch(t -> Objects.equals(this.getTypeId(t.getImportedType()), this.getTypeId(type)));
    }

    private String getTypeId(MetadataType type) {
        return ExtensionMetadataTypeUtils.getId(type).get();
    }

    TopLevelElement createTypeRef(DslElementSyntax typeDsl, ObjectType type, boolean isRequired) {
        if (!this.isImported(type)) {
            this.objectTypeDelegate.registerPojoType(type, "");
            this.objectTypeDelegate.registerAbstractElement(type, typeDsl);
            this.objectTypeDelegate.registerConcreteGlobalElement(typeDsl, "", ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), this.objectTypeDelegate.getTypeQName(typeDsl, type));
        }
        QName refQName = new QName(typeDsl.getNamespace(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), typeDsl.getPrefix());
        return this.createRefElement(refQName, isRequired);
    }

    void declareAsParameter(MetadataType type, ExtensionType extensionType, ParameterModel parameterModel, DslElementSyntax paramDsl, List<TopLevelElement> childElements) {
        if (ExtensionModelUtils.isContent(parameterModel)) {
            childElements.add(this.generateTextElement(paramDsl, parameterModel.getDescription(), parameterModel.isRequired()));
        } else {
            type.accept(this.getParameterDeclarationVisitor(extensionType, childElements, parameterModel));
        }
    }

    private MetadataTypeVisitor getParameterDeclarationVisitor(ExtensionType extensionType, List<TopLevelElement> childElements, ParameterModel parameterModel) {
        DslElementSyntax paramDsl = this.dslResolver.resolve(parameterModel);
        return this.getParameterDeclarationVisitor(extensionType, childElements, parameterModel.getName(), parameterModel.getDescription(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getDefaultValue(), paramDsl, parameterModel.getDslConfiguration());
    }

    private MetadataTypeVisitor getParameterDeclarationVisitor(final ExtensionType extensionType, final List<TopLevelElement> childElements, final String name, final String description, final ExpressionSupport expressionSupport, final boolean required, final Object defaultValue, final DslElementSyntax paramDsl, final ParameterDslConfiguration dslModel) {
        return new MetadataTypeVisitor(){
            private final boolean forceOptional;
            {
                this.forceOptional = paramDsl.supportsChildDeclaration() || !required;
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit(arrayType);
                if (paramDsl.supportsChildDeclaration()) {
                    SchemaBuilder.this.collectionDelegate.generateCollectionElement(arrayType, paramDsl, description, !paramDsl.supportsAttributeDeclaration(), childElements);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                this.defaultVisit(objectType);
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    if (paramDsl.supportsChildDeclaration()) {
                        SchemaBuilder.this.mapDelegate.generateMapElement(objectType, paramDsl, description, !paramDsl.supportsAttributeDeclaration(), childElements);
                    }
                } else {
                    SchemaBuilder.this.objectTypeDelegate.generatePojoElement(objectType, paramDsl, dslModel, description, childElements, required);
                }
            }

            @Override
            public void visitString(StringType stringType) {
                if (paramDsl.supportsChildDeclaration()) {
                    childElements.add(SchemaBuilder.this.generateTextElement(paramDsl, description, this.isRequired(this.forceOptional, required)));
                } else {
                    this.defaultVisit(stringType);
                }
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (paramDsl.supportsAttributeDeclaration()) {
                    extensionType.getAttributeOrAttributeGroup().add(SchemaBuilder.this.createAttribute(name, description, metadataType, defaultValue, this.isRequired(this.forceOptional, required), expressionSupport));
                }
            }

            private boolean isRequired(boolean forceOptional, boolean required2) {
                return !forceOptional && required2;
            }
        };
    }

    private XmlDslModel registerExtensionImport(ExtensionModel extension) {
        XmlDslModel languageModel = extension.getXmlDslModel();
        Import schemaImport = new Import();
        schemaImport.setNamespace(languageModel.getNamespace());
        schemaImport.setSchemaLocation(languageModel.getSchemaLocation());
        if (!this.schema.getIncludeOrImportOrRedefine().contains(schemaImport)) {
            this.schema.getIncludeOrImportOrRedefine().add(schemaImport);
        }
        return languageModel;
    }

    void addTlsSupport(ExtensionType extensionType) {
        if (!this.requiresTls) {
            this.importTlsNamespace();
            this.requiresTls = true;
        }
        extensionType.getAttributeOrAttributeGroup().add(this.createAttribute("tlsContext", this.STRING_TYPE, false, ExpressionSupport.NOT_SUPPORTED));
    }

    void addTlsSupport(ExtensionType extensionType, List<TopLevelElement> childElements) {
        this.addTlsSupport(extensionType);
        childElements.add(this.createRefElement(SchemaConstants.TLS_CONTEXT_TYPE, false));
    }

    void addSchedulerSupport(List<TopLevelElement> childElements) {
        childElements.add(this.createRefElement(SchemaConstants.SCHEDULING_STRATEGY_ELEMENT, true));
    }

    TopLevelElement createRefElement(QName elementRef, boolean isRequired) {
        TopLevelElement element = new TopLevelElement();
        element.setRef(elementRef);
        element.setMinOccurs(isRequired ? BigInteger.ONE : BigInteger.ZERO);
        element.setMaxOccurs("1");
        return element;
    }

    NamedGroup createGroup(QName elementRef, boolean isRequired) {
        NamedGroup namedGroup = new NamedGroup();
        namedGroup.setRef(elementRef);
        namedGroup.setMinOccurs(isRequired ? BigInteger.ONE : BigInteger.ZERO);
        return namedGroup;
    }

    Attribute createAttribute(String name, String description, boolean optional, QName type) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        return attr;
    }

    Schema getSchema() {
        return this.schema;
    }

    TypeCatalog getTypesMapping() {
        return this.typesMapping;
    }

    Annotation createDocAnnotation(String content) {
        if (org.mule.runtime.core.api.util.StringUtils.isBlank(content)) {
            return null;
        }
        Annotation annotation = new Annotation();
        Documentation doc = new Documentation();
        doc.getContent().add(content);
        annotation.getAppinfoOrDocumentation().add(doc);
        return annotation;
    }

    TopLevelElement createTopLevelElement(String name, BigInteger minOccurs, String maxOccurs) {
        TopLevelElement element = new TopLevelElement();
        element.setName(name);
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        return element;
    }

    TopLevelElement createTopLevelElement(String name, BigInteger minOccurs, String maxOccurs, LocalComplexType type) {
        TopLevelElement element = this.createTopLevelElement(name, minOccurs, maxOccurs);
        element.setComplexType(type);
        return element;
    }

    ObjectTypeSchemaDelegate getObjectSchemaDelegate() {
        return this.objectTypeDelegate;
    }

    ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    private TopLevelElement generateTextElement(DslElementSyntax paramDsl, String description, boolean isRequired) {
        TopLevelElement textElement = this.createTopLevelElement(paramDsl.getElementName(), isRequired ? BigInteger.ONE : BigInteger.ZERO, "1");
        textElement.setAnnotation(this.createDocAnnotation(description));
        textElement.setType(SchemaConstants.STRING);
        return textElement;
    }

    boolean isRequired(TopLevelElement element) {
        return element.getMinOccurs().equals(BigInteger.ONE);
    }

    void addParameterToSequence(List<TopLevelElement> parameters, ExplicitGroup sequence) {
        parameters.forEach(parameter -> {
            sequence.getParticle().add(this.objectFactory.createElement((TopLevelElement)parameter));
            if (this.isRequired((TopLevelElement)parameter)) {
                sequence.setMinOccurs(BigInteger.ONE);
            }
        });
    }

    void addInfrastructureParameters(ExtensionType extensionType, ParameterizedModel model, ExplicitGroup sequence) {
        model.getAllParameterModels().stream().filter(p -> p.getModelProperty(InfrastructureParameterModelProperty.class).map(infraParam -> !p.getName().equals("errorMappings")).orElse(false)).sorted(Comparator.comparing(p -> p.getModelProperty(InfrastructureParameterModelProperty.class).get().getSequence())).forEach(parameter -> {
            boolean isParameterRequired = parameter.isRequired() && !parameter.getDslConfiguration().allowsReferences() && !parameter.getDslConfiguration().allowTopLevelDefinition();
            parameter.getModelProperty(QNameModelProperty.class).map(QNameModelProperty::getValue).ifPresent(qName -> this.addParameterToSequence(Arrays.asList(this.createRefElement((QName)qName, isParameterRequired)), sequence));
            if (parameter.getName().equals("tlsContext")) {
                this.addTlsSupport(extensionType);
            }
        });
    }

    void addInlineParameterGroup(ParameterGroupModel group, ExplicitGroup parentSequence) {
        DslElementSyntax groupDsl = this.dslResolver.resolveInline(group);
        LocalComplexType complexType = this.objectTypeDelegate.createTypeExtension(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        ExplicitGroup groupSequence = new ExplicitGroup();
        List<ParameterModel> groupParameters = group.getParameterModels();
        List<TopLevelElement> parameterElements = this.registerParameters(complexType.getComplexContent().getExtension(), groupParameters);
        this.addParameterToSequence(parameterElements, groupSequence);
        BigInteger minOccurs = ExtensionModelUtils.isRequired(group) ? BigInteger.ONE : BigInteger.ZERO;
        TopLevelElement groupElement = this.createTopLevelElement(groupDsl.getElementName(), minOccurs, "1");
        groupElement.setComplexType(complexType);
        complexType.getComplexContent().getExtension().setSequence(groupSequence);
        parentSequence.getParticle().add(this.objectFactory.createElement(groupElement));
    }

    QName resolveSubstitutionGroup(SubstitutionGroup userConfiguredSubstitutionGroup) {
        String namespaceUri = this.getNamespaceUri(userConfiguredSubstitutionGroup.getPrefix());
        return new QName(namespaceUri, userConfiguredSubstitutionGroup.getElement(), userConfiguredSubstitutionGroup.getPrefix());
    }

    String getNamespaceUri(String prefix) {
        if (prefix.equals("mule")) {
            this.importIfNotImported(this.createMuleImport());
            return DslConstants.CORE_NAMESPACE;
        }
        if (prefix.equals("ee")) {
            this.importIfNotImported(this.createMuleEEImport());
            return DslConstants.EE_NAMESPACE;
        }
        Optional<ExtensionModel> extensionModelFromPrefix = this.dslContext.getExtensions().stream().filter(extensionModel -> prefix.equals(extensionModel.getXmlDslModel().getPrefix())).findFirst();
        if (extensionModelFromPrefix.isPresent()) {
            this.registerExtensionImport(extensionModelFromPrefix.get());
            return extensionModelFromPrefix.get().getXmlDslModel().getNamespace();
        }
        throw new IllegalArgumentException(String.format("prefix: %s inside substitutionGroup does not exist. It does not relate to any imported namespaces", prefix));
    }
}

