/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.interception.HasParamsAsTemplateProcessor;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;

public class ParseTemplateProcessor
extends SimpleMessageProcessor
implements HasParamsAsTemplateProcessor {
    private static final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    private static final Boolean KEEP_TYPE_TARGET_AND_TARGET_VAR = new Boolean(System.getProperty("mule.parse.template.keep.target.var.type", "true"));
    private static final String LEGACY_DEFAULT_TARGET_VALUE = "#[message]";
    private ExtendedExpressionManager expressionManager;
    private String content;
    private MediaType outputMimeType;
    private Charset outputEncoding;
    private String target;
    private String location;
    private String targetValue;
    private CompiledExpression targetValueExpression;

    @Override
    public void initialise() throws InitialisationException {
        if (this.content != null && this.location != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Can't define both location and content at the same time"), (Initialisable)this);
        }
        if (this.content == null && this.location == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("One of 'location' or 'content' should be defined but they are both null"), (Initialisable)this);
        }
        if (this.location != null) {
            this.loadContentFromLocation();
            if (this.outputMimeType == null) {
                this.guessMimeType();
            }
        }
        if (this.targetValue != null) {
            this.targetValueExpression = ExpressionLanguageUtils.compile(this.targetValue, this.expressionManager);
        }
    }

    private void loadContentFromLocation() throws InitialisationException {
        InputStream contentStream = null;
        try {
            contentStream = IOUtils.getResourceAsStream(this.location, this.getClass());
            if (contentStream == null) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Template location: " + this.location + " not found"), (Initialisable)this);
            }
            this.content = this.outputEncoding != null ? IOUtils.toString(contentStream, this.outputEncoding) : IOUtils.toString(contentStream);
        }
        catch (IOException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Error loading template from location"), (Initialisable)this);
        }
        finally {
            if (contentStream != null) {
                IOUtils.closeQuietly(contentStream);
            }
        }
    }

    private void guessMimeType() {
        MediaType fromLocationMediaType = MediaType.parse(mimetypesFileTypeMap.getContentType(this.location));
        if (!MediaType.BINARY.equals(fromLocationMediaType)) {
            this.outputMimeType = fromLocationMediaType;
        }
    }

    private void evaluateCorrectArguments() {
        if (!(this.target != null || ExpressionLanguageUtils.isSanitizedPayload(ExpressionLanguageUtils.sanitize(this.targetValue)) || MuleSystemProperties.isParseTemplateUseLegacyDefaultTargetValue() && LEGACY_DEFAULT_TARGET_VALUE.equals(this.targetValue))) {
            throw new IllegalArgumentException("Can't define a targetValue with no target");
        }
    }

    private MediaType buildMediaType() {
        if (this.outputMimeType != null) {
            if (this.outputEncoding != null) {
                return MediaType.create(this.outputMimeType.getPrimaryType(), this.outputMimeType.getSubType(), this.outputEncoding);
            }
            return this.outputMimeType;
        }
        return null;
    }

    @Override
    public CoreEvent process(CoreEvent event) {
        this.evaluateCorrectArguments();
        String result = this.expressionManager.parseLogTemplate(this.content, event, this.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
        Message.Builder messageBuilder = Message.builder(event.getMessage()).value(result).nullAttributesValue();
        MediaType configuredMediaType = this.buildMediaType();
        if (configuredMediaType != null) {
            messageBuilder.mediaType(configuredMediaType);
        }
        Message resultMessage = messageBuilder.build();
        if (this.target == null) {
            return CoreEvent.builder(event).message(resultMessage).build();
        }
        if (KEEP_TYPE_TARGET_AND_TARGET_VAR.booleanValue()) {
            CoreEvent resultEvent = CoreEvent.builder(event).message(resultMessage).build();
            return Operators.outputToTarget(event, resultEvent, this.target, this.targetValueExpression, this.expressionManager);
        }
        return CoreEvent.builder(event).addVariable(this.target, this.expressionManager.evaluate(this.targetValue, CoreEvent.builder(event).message(resultMessage).build())).build();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setOutputMimeType(String outputMimeType) {
        this.outputMimeType = MediaType.parseDefinedInApp(outputMimeType);
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = Charset.forName(encoding);
    }

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

