/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamBuffer
extends AbstractStreamingBuffer
implements InputStreamBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamBuffer.class);
    protected final InputStream stream;
    protected final ByteBufferManager bufferManager;
    protected boolean streamFullyConsumed = false;

    public AbstractInputStreamBuffer(InputStream stream, ByteBufferManager bufferManager) {
        this.stream = stream;
        this.bufferManager = bufferManager;
    }

    public abstract int consumeForwardData() throws IOException;

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.writeLock.lock();
            try {
                this.doClose();
            }
            finally {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug("Found exception trying to close InputStream", (Throwable)e);
                    }
                }
                this.writeLock.unlock();
            }
        }
    }

    public abstract void doClose();

    @Override
    public final ByteBuffer get(long position, int length) throws IOException {
        Preconditions.checkState(!this.closed.get(), "Buffer is closed");
        return this.doGet(position, length);
    }

    protected abstract ByteBuffer doGet(long var1, int var3) throws IOException;

    protected int consumeStream(ByteBuffer buffer) throws IOException {
        byte[] dest = buffer.array();
        int totalRead = 0;
        int remaining = buffer.remaining();
        int offset = buffer.position();
        while (remaining > 0) {
            try {
                int available = this.stream.available();
                if (totalRead <= 0 || available >= 1) {
                    int read = this.stream.read(dest, offset, this.readLength(remaining, available));
                    if (read == -1) {
                        this.streamFullyConsumed = true;
                        if (totalRead == 0) {
                            return -1;
                        }
                    } else if (read != 0) {
                        totalRead += read;
                        remaining -= read;
                        offset += read;
                        if (available <= 0) continue;
                        return this.advanceBufferPosition(buffer, totalRead, offset);
                    }
                }
                break;
            }
            catch (IOException e) {
                return this.handleIoException(e, totalRead);
            }
        }
        return this.advanceBufferPosition(buffer, totalRead, offset);
    }

    private int readLength(int remaining, int available) {
        return available > 0 ? Math.min(remaining, available) : remaining;
    }

    private int advanceBufferPosition(ByteBuffer buffer, int totalRead, int offset) {
        if (totalRead > 0) {
            buffer.position(offset);
        }
        return totalRead;
    }

    private int handleIoException(IOException ioe, int totalRead) throws IOException {
        if (!Thread.interrupted()) {
            throw ioe;
        }
        Thread thread = Thread.currentThread();
        thread.interrupt();
        LOGGER.warn("Thread {} interrupted while reading from stream.", (Object)thread.getName());
        if (totalRead == 0 || this.closed.get()) {
            this.streamFullyConsumed = true;
            return -1;
        }
        throw ioe;
    }

    protected abstract ByteBuffer copy(long var1, int var3);
}

