/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.internal.util.FeatureFlaggingUtils;

public abstract class NativeLibraryLoaderMuleDeployableArtifactClassLoader
extends MuleDeployableArtifactClassLoader {
    public static final String METHOD_NAME = "loadLibrary";
    private final NativeLibraryFinder nativeLibraryFinder;
    protected final boolean supportNativeLibraryDependencies;
    private static final AtomicBoolean areFeatureFlagsConfigured;
    private final LazyValue<Class<?>> dynamicLibraryLoader = new LazyValue<Supplier<Class>>(this::getDynamicLibraryLoader);

    public Class<?> getDynamicLibraryLoader() {
        return new ByteBuddy().subclass(Object.class).defineMethod(METHOD_NAME, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{String.class}).intercept((Implementation)MethodDelegation.to(System.class)).make().load((ClassLoader)this, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    protected NativeLibraryLoaderMuleDeployableArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parentCl, NativeLibraryFinder nativeLibraryFinder, List<URL> urls, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, urls.toArray(new URL[0]), parentCl, lookupPolicy);
        this.nativeLibraryFinder = nativeLibraryFinder;
        this.supportNativeLibraryDependencies = FeatureFlaggingUtils.isFeatureEnabled(MuleRuntimeFeature.SUPPORT_NATIVE_LIBRARY_DEPENDENCIES, artifactDescriptor);
    }

    protected void loadNativeLibraryDependencies(String nativeLibraryName) {
        if (!this.dynamicLibraryLoader.isComputed()) {
            Method method;
            Class<?> loader = this.dynamicLibraryLoader.get();
            try {
                method = loader.getMethod(METHOD_NAME, String.class);
            }
            catch (NoSuchMethodException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create native library loader."), (Throwable)e);
            }
            List<String> nativeLibraries = this.nativeLibraryFinder.findLibraryNames();
            nativeLibraries.remove(nativeLibraryName);
            Collections.reverse(nativeLibraries);
            for (String nativeLibrary : nativeLibraries) {
                try {
                    method.invoke(loader.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), nativeLibrary);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not load %s native library.", nativeLibrary), (Throwable)e);
                }
            }
        }
    }

    private static void configureSupportNativeLibraryDependencies() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.SUPPORT_NATIVE_LIBRARY_DEPENDENCIES, NativeLibraryLoaderMuleDeployableArtifactClassLoader.minMuleVersion("4.6.0"));
    }

    private static Predicate<FeatureContext> minMuleVersion(String version) {
        return featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(version)).isPresent();
    }

    static {
        NativeLibraryLoaderMuleDeployableArtifactClassLoader.registerAsParallelCapable();
        areFeatureFlagsConfigured = new AtomicBoolean();
        if (!areFeatureFlagsConfigured.getAndSet(true)) {
            NativeLibraryLoaderMuleDeployableArtifactClassLoader.configureSupportNativeLibraryDependencies();
        }
    }
}

