/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.module.extension.internal.runtime.resolver.LifecycleAwareValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public final class NativeQueryParameterValueResolver
extends LifecycleAwareValueResolverWrapper<String> {
    private static final DsqlParser dsqlParser = DsqlParser.getInstance();
    private static final String ERROR = "Error creating QueryTranslator [%s], query translators must have a default constructor";
    private final Class<? extends QueryTranslator> translatorClass;

    public NativeQueryParameterValueResolver(ValueResolver<String> queryResolver, Class<? extends QueryTranslator> translator) {
        super(queryResolver);
        this.translatorClass = translator;
    }

    @Override
    public String resolve(ValueResolvingContext context) throws MuleException {
        String query = (String)super.resolve(context);
        if (!DsqlParser.isDsqlQuery(query)) {
            return query;
        }
        DsqlQuery dsqlQuery = dsqlParser.parse(query);
        QueryTranslator queryTranslator = this.instantiateTranslator(this.translatorClass);
        return dsqlQuery.translate(queryTranslator);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private QueryTranslator instantiateTranslator(Class<? extends QueryTranslator> translator) {
        try {
            return translator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(String.format(ERROR, translator.getSimpleName()));
        }
    }
}

