/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.security.adapter;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.runtime.security.adapter.MuleAuthenticationAdapter;
import org.mule.runtime.module.extension.internal.runtime.security.adapter.MuleCredentialsAdapter;
import org.mule.runtime.module.extension.internal.runtime.security.adapter.SdkAuthenticationAdapter;
import org.mule.runtime.module.extension.internal.runtime.security.adapter.SdkCredentialsBuilderAdapter;
import org.mule.sdk.api.security.Authentication;
import org.mule.sdk.api.security.Credentials;
import org.mule.sdk.api.security.CredentialsBuilder;

public class SdkAuthenticationHandlerAdapter
implements org.mule.sdk.api.security.AuthenticationHandler {
    private final AuthenticationHandler delegate;

    public SdkAuthenticationHandlerAdapter(AuthenticationHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setAuthentication(Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        this.delegate.setAuthentication(new MuleAuthenticationAdapter(authentication));
    }

    @Override
    public void setAuthentication(List<String> list, Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        this.delegate.setAuthentication(list, new MuleAuthenticationAdapter(authentication));
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return this.delegate.getAuthentication().map(SdkAuthenticationAdapter::new);
    }

    @Override
    public Authentication createAuthentication(Credentials credentials) {
        return new SdkAuthenticationAdapter(this.delegate.createAuthentication(new MuleCredentialsAdapter(credentials)));
    }

    @Override
    public CredentialsBuilder createCredentialsBuilder() {
        return new SdkCredentialsBuilderAdapter(this.delegate.createCredentialsBuilder());
    }
}

