/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.mule.runtime.module.extension.internal.capability.xml.schema.ClasspathBasedDslContext;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;

abstract class AbstractXmlResourceFactory
implements DslResourceFactory {
    AbstractXmlResourceFactory() {
    }

    @Override
    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        Set<ImportedTypeModel> importedTypes = extensionModel.getImportedTypes();
        DslResolvingContext dslContext = importedTypes.isEmpty() ? new NullDslResolvingContext() : new ClasspathBasedDslContext(extensionModel.getModelProperty(ImplementingTypeModelProperty.class).map(mp -> mp.getType().getClassLoader()).orElse(Thread.currentThread().getContextClassLoader()));
        return this.generateResource(extensionModel, dslContext);
    }

    @Override
    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel, DslResolvingContext context) {
        XmlDslModel languageModel = extensionModel.getXmlDslModel();
        return languageModel == null ? Optional.empty() : Optional.of(this.generateXmlResource(extensionModel, languageModel, context));
    }

    protected abstract GeneratedResource generateXmlResource(ExtensionModel var1, XmlDslModel var2, DslResolvingContext var3);

    protected String escape(String content) {
        return content.replaceAll(":", "\\\\:");
    }
}

