/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.builder.GraphBuilder;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.mule.internal.dsl.MuleSdkDslConstants;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkErrorModelParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSdkErrorsDeclarationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleSdkErrorsDeclarationParser.class);
    private static final String MULE = "mule".toUpperCase(Locale.getDefault());
    private static final ComponentIdentifier MULE_ANY = IdentifierParsingUtils.parseErrorType("ANY", MULE);
    private final ArtifactAst artifactAst;
    private final String extensionErrorNamespace;
    private Map<ComponentIdentifier, ErrorModelParser> parserByIdentifier;

    public MuleSdkErrorsDeclarationParser(ArtifactAst artifactAst, String extensionErrorNamespace) {
        this.artifactAst = artifactAst;
        this.extensionErrorNamespace = extensionErrorNamespace;
        this.parserByIdentifier = null;
    }

    public Map<ComponentIdentifier, ErrorModelParser> parse() {
        if (this.parserByIdentifier == null) {
            this.parserByIdentifier = MuleSdkErrorsDeclarationParser.doParse(this.artifactAst, this.extensionErrorNamespace);
        }
        return this.parserByIdentifier;
    }

    private static Map<ComponentIdentifier, ErrorModelParser> doParse(ArtifactAst artifactAst, String extensionErrorNamespace) {
        Map<ComponentIdentifier, ComponentIdentifier> errorIdToParentId = MuleSdkErrorsDeclarationParser.extractMappingFromErrorsToParent(artifactAst, extensionErrorNamespace);
        Graph<ComponentIdentifier, DefaultEdge> graph = MuleSdkErrorsDeclarationParser.buildTransposedGraph(errorIdToParentId);
        HashMap<ComponentIdentifier, ErrorModelParser> parserByIdentifier = new HashMap<ComponentIdentifier, ErrorModelParser>();
        try {
            new TopologicalOrderIterator(graph).forEachRemaining(errorIdentifier -> {
                ErrorModelParser parent = MuleSdkErrorsDeclarationParser.getParent(errorIdToParentId, parserByIdentifier, errorIdentifier);
                LOGGER.debug("Creating parser for error '{}' with parent '{}'", errorIdentifier, (Object)parent);
                parserByIdentifier.put((ComponentIdentifier)errorIdentifier, new MuleSdkErrorModelParser(errorIdentifier.getNamespace(), errorIdentifier.getName(), parent));
            });
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error while trying to parse the errors hierarchy, maybe there is a cycle", e);
        }
        return parserByIdentifier;
    }

    private static ErrorModelParser getParent(Map<ComponentIdentifier, ComponentIdentifier> errorIdToParentId, Map<ComponentIdentifier, ErrorModelParser> parserByIdentifier, ComponentIdentifier errorIdentifier) {
        if (errorIdentifier.equals(MULE_ANY)) {
            return null;
        }
        return parserByIdentifier.get(errorIdToParentId.get(errorIdentifier));
    }

    private static Graph<ComponentIdentifier, DefaultEdge> buildTransposedGraph(Map<ComponentIdentifier, ComponentIdentifier> edges) {
        GraphBuilder graphBuilder = DefaultDirectedGraph.createBuilder(DefaultEdge.class);
        edges.forEach((source, destination) -> graphBuilder.addEdge(destination, source));
        return graphBuilder.buildAsUnmodifiable();
    }

    private static Map<ComponentIdentifier, ComponentIdentifier> extractMappingFromErrorsToParent(ArtifactAst artifactAst, String extensionErrorNamespace) {
        HashMap<ComponentIdentifier, ComponentIdentifier> errorToParent = new HashMap<ComponentIdentifier, ComponentIdentifier>();
        artifactAst.topLevelComponentsStream().filter(c -> c.getIdentifier().equals(MuleSdkDslConstants.MULE_SDK_EXTENSION_DSL_ERRORS_CONSTRUCT_IDENTIFIER)).forEach(errorsAst -> errorsAst.directChildrenStreamByIdentifier("extension", "error").forEach(errorAst -> {
            ComponentIdentifier errorIdentifier = MuleSdkErrorsDeclarationParser.getType(extensionErrorNamespace, errorAst);
            ComponentIdentifier parentIdentifier = MuleSdkErrorsDeclarationParser.getParent(extensionErrorNamespace, errorAst);
            MuleSdkErrorsDeclarationParser.validateMapping(errorIdentifier, parentIdentifier, extensionErrorNamespace);
            LOGGER.debug("Found declared error type '{}' with parent '{}' in the AST", (Object)errorIdentifier, (Object)parentIdentifier);
            errorToParent.put(errorIdentifier, parentIdentifier);
        }));
        return errorToParent;
    }

    private static void validateMapping(ComponentIdentifier errorIdentifier, ComponentIdentifier parentIdentifier, String extensionErrorNamespace) {
        String errorNamespace = errorIdentifier.getNamespace();
        String parentNamespace = parentIdentifier.getNamespace();
        if (!errorNamespace.equals(extensionErrorNamespace)) {
            throw new IllegalArgumentException(String.format("The extension with namespace '%s' can't declare the error '%s' with namespace '%s'", extensionErrorNamespace, errorIdentifier, errorNamespace));
        }
        if (!parentNamespace.equals(extensionErrorNamespace) && !parentNamespace.equals(MULE)) {
            throw new IllegalArgumentException(String.format("The error '%s' can't declare '%s' as parent. It can only have a parent with namespace '%s' or '%s'", errorIdentifier, parentIdentifier, extensionErrorNamespace, MULE));
        }
    }

    private static ComponentIdentifier getParent(String extensionErrorNamespace, ComponentAst errorAst) {
        return errorAst.getParameter("General", "parent").getValue().getValue().map(asString -> IdentifierParsingUtils.parseErrorType(asString, extensionErrorNamespace)).orElse(MULE_ANY);
    }

    private static ComponentIdentifier getType(String extensionErrorNamespace, ComponentAst errorAst) {
        return errorAst.getParameter("General", "type").getValue().getValue().map(asString -> IdentifierParsingUtils.parseErrorType(asString, extensionErrorNamespace)).get();
    }
}

