/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.internal.model.MavenPomModelWrapper;
import org.mule.maven.pom.parser.internal.util.FileUtils;
import org.mule.maven.pom.parser.internal.util.MavenUtils;

public class MavenModelBuilderImpl
implements MavenModelBuilder {
    public static final String MULE_POM = "pom.xml";
    public static final String MULE_POM_PROPERTIES = "pom.properties";
    public static final String SHARED_LIBRARY_FIELD = "sharedLibrary";
    public static final String ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD = "additionalPluginDependencies";
    public static final String ADDITIONAL_DEPENDENCIES_FIELD = "additionalDependencies";
    public static final String DEPENDENCY_FIELD = "dependency";
    public static final String PLUGIN_FIELD = "plugin";
    public static final String VERSION_FIELD = "version";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GROUP_ID = "groupId";
    private static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    private static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final Model model;

    public static MavenModelBuilder getDefaultModelBuilder() {
        return new MavenModelBuilderImpl(GROUP_ID, ARTIFACT_ID, "1.0", Optional.empty(), Optional.empty());
    }

    public MavenModelBuilderImpl(String groupId, String artifactId, String version, Optional<String> modelVersion, Optional<String> packaging) {
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        this.model = new Model();
        this.model.setGroupId(groupId);
        this.model.setArtifactId(artifactId);
        this.model.setVersion(version);
        this.model.setDependencies(this.dependencies);
        packaging.ifPresent(this.model::setPackaging);
        modelVersion.ifPresent(this.model::setModelVersion);
    }

    public MavenModelBuilderImpl(Path path) {
        Objects.requireNonNull(path, "path cannot be null");
        this.model = MavenUtils.getPomModel(path.toFile());
    }

    @Override
    public void addAdditionalPluginDependency(AdditionalPluginDependencies additionalPluginDependencies) {
        Xpp3Dom additionalPluginDependenciesDom;
        Plugin mavenPlugin = this.getOrCreateMuleMavenPlugin();
        Xpp3Dom configuration = (Xpp3Dom)mavenPlugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            mavenPlugin.setConfiguration(configuration);
        }
        if ((additionalPluginDependenciesDom = configuration.getChild(ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD)) == null) {
            additionalPluginDependenciesDom = new Xpp3Dom(ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD);
            configuration.addChild(additionalPluginDependenciesDom);
        }
        Xpp3Dom[] pluginDoms = additionalPluginDependenciesDom.getChildren(PLUGIN_FIELD);
        Xpp3Dom finalAdditionalPluginDependenciesDom = additionalPluginDependenciesDom;
        Xpp3Dom additionalDependenciesForPlugin = Arrays.stream(pluginDoms).filter(plugin -> {
            String libraryGroupId = MavenUtils.getAttribute(plugin, GROUP_ID);
            String libraryArtifactId = MavenUtils.getAttribute(plugin, ARTIFACT_ID);
            return additionalPluginDependencies.getGroupId().equals(libraryGroupId) && additionalPluginDependencies.getArtifactId().equals(libraryArtifactId);
        }).findAny().orElseGet(() -> this.createPluginDom(finalAdditionalPluginDependenciesDom, additionalPluginDependencies));
        Xpp3Dom additionalDependenciesDom = this.getOrCreateAdditionalDependenciesDom(additionalDependenciesForPlugin);
        this.addAdditionalPluginDependency(additionalDependenciesDom, additionalPluginDependencies.getAdditionalDependencies());
    }

    @Override
    public void addSharedLibraryDependency(String groupId, String artifactId) {
        Optional<Xpp3Dom> sharedLibrary;
        Xpp3Dom[] sharedLibraries;
        Xpp3Dom sharedLibrariesDom;
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        Plugin plugin = this.getOrCreateMuleMavenPlugin();
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            plugin.setConfiguration(configuration);
        }
        if ((sharedLibrariesDom = configuration.getChild("sharedLibraries")) == null) {
            sharedLibrariesDom = new Xpp3Dom("sharedLibraries");
            configuration.addChild(sharedLibrariesDom);
        }
        if ((sharedLibraries = sharedLibrariesDom.getChildren(SHARED_LIBRARY_FIELD)) != null && (sharedLibrary = Arrays.stream(sharedLibraries).filter(sharedLib -> {
            String libraryGroupId = MavenUtils.getAttribute(sharedLib, GROUP_ID);
            String libraryArtifactId = MavenUtils.getAttribute(sharedLib, ARTIFACT_ID);
            return groupId.equals(libraryGroupId) && artifactId.equals(libraryArtifactId);
        }).findAny()).isPresent()) {
            return;
        }
        Xpp3Dom sharedLibraryDom = new Xpp3Dom(SHARED_LIBRARY_FIELD);
        sharedLibrariesDom.addChild(sharedLibraryDom);
        Xpp3Dom groupIdDom = new Xpp3Dom(GROUP_ID);
        groupIdDom.setValue(groupId);
        sharedLibraryDom.addChild(groupIdDom);
        Xpp3Dom artifactIdDom = new Xpp3Dom(ARTIFACT_ID);
        artifactIdDom.setValue(artifactId);
        sharedLibraryDom.addChild(artifactIdDom);
    }

    @Override
    public void createDeployablePomFile(Path artifactFolder) {
        Objects.requireNonNull(artifactFolder, "the artifactFolder's path cannot be null");
        File pomFileLocation = new File(artifactFolder.toFile(), Paths.get("META-INF", "maven", this.model.getGroupId(), this.model.getArtifactId(), MULE_POM).toString());
        try {
            this.createFile(pomFileLocation.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileWriter fileWriter = new FileWriter(pomFileLocation);){
            new MavenXpp3Writer().write(fileWriter, this.model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createDeployablePomProperties(Path artifactFolder, Properties properties) {
        Objects.requireNonNull(artifactFolder, "the artifactFolder's path cannot be null");
        Objects.requireNonNull(properties, "property cannot be null");
        File pomPropertiesFileLocation = new File(artifactFolder.toFile(), Paths.get("META-INF", "maven", this.model.getGroupId(), this.model.getArtifactId(), MULE_POM_PROPERTIES).toString());
        if (!pomPropertiesFileLocation.exists()) {
            try {
                this.createFile(pomPropertiesFileLocation.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileWriter fileWriter = new FileWriter(pomPropertiesFileLocation);){
            properties.store(fileWriter, "Writing pom.properties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateArtifactPom(Path path) {
        Objects.requireNonNull(path, "path cannot be null");
        File mulePluginPom = path.toFile();
        if (mulePluginPom.isDirectory()) {
            mulePluginPom = this.lookupPomFromMavenLocation(mulePluginPom);
        }
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try (FileOutputStream outputStream = new FileOutputStream(mulePluginPom);){
            writer.write(outputStream, this.model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addDependency(BundleDependency bundleDependency) {
        Objects.requireNonNull(bundleDependency, "The bundleDependency cannot be null");
        this.model.addDependency(this.createMavenDependency(bundleDependency));
    }

    @Override
    public void addRepository(String id, String name, String url) {
        Repository repository = new Repository();
        repository.setId(id);
        repository.setName(name);
        repository.setUrl(url);
        this.model.addRepository(repository);
    }

    @Override
    public MavenPomModel getModel() {
        return new MavenPomModelWrapper(this.model);
    }

    @Override
    public MavenModelBuilder.MavenProfileBuilder getNewMavenProfileBuilder() {
        return new MavenProfileBuilderImpl();
    }

    private Plugin getOrCreateMuleMavenPlugin() {
        List<Plugin> plugins;
        Build build = this.model.getBuild();
        if (build == null) {
            build = new Build();
            this.model.setBuild(build);
        }
        if ((plugins = build.getPlugins()) == null) {
            plugins = new ArrayList<Plugin>();
            build.setPlugins(plugins);
        }
        Optional<Plugin> pluginOptional = plugins.stream().filter(plugin -> plugin.getGroupId().equals(MULE_MAVEN_PLUGIN_GROUP_ID) && plugin.getArtifactId().equals(MULE_MAVEN_PLUGIN_ARTIFACT_ID)).findFirst();
        List<Plugin> finalPlugins = plugins;
        Plugin plugin2 = pluginOptional.orElseGet(() -> {
            Plugin muleMavenPlugin = new Plugin();
            muleMavenPlugin.setGroupId(MULE_MAVEN_PLUGIN_GROUP_ID);
            muleMavenPlugin.setArtifactId(MULE_MAVEN_PLUGIN_ARTIFACT_ID);
            finalPlugins.add(muleMavenPlugin);
            return muleMavenPlugin;
        });
        return plugin2;
    }

    private Xpp3Dom getOrCreateAdditionalDependenciesDom(Xpp3Dom pluginDom) {
        Xpp3Dom additionalDependenciesDom = pluginDom.getChild(ADDITIONAL_DEPENDENCIES_FIELD);
        if (additionalDependenciesDom == null) {
            additionalDependenciesDom = new Xpp3Dom(ADDITIONAL_DEPENDENCIES_FIELD);
            pluginDom.addChild(additionalDependenciesDom);
        }
        return additionalDependenciesDom;
    }

    private void addAdditionalPluginDependency(Xpp3Dom additionalDependenciesDom, List<BundleDescriptor> descriptors) {
        Xpp3Dom[] dependencyDoms = additionalDependenciesDom.getChildren(DEPENDENCY_FIELD);
        descriptors.forEach(descriptor -> {
            Optional<Xpp3Dom> dependency = Arrays.stream(dependencyDoms).filter(d -> {
                String dependencyGroupId = MavenUtils.getAttribute(d, GROUP_ID);
                String dependencyArtifactId = MavenUtils.getAttribute(d, ARTIFACT_ID);
                return descriptor.getGroupId().equals(dependencyGroupId) && descriptor.getArtifactId().equals(dependencyArtifactId);
            }).findAny();
            if (dependency.isPresent()) {
                if (!descriptor.getVersion().equals(MavenUtils.getAttribute(dependency.get(), VERSION_FIELD))) {
                    throw new RuntimeException("Trying to add an additionalDependency already added with a different version");
                }
                return;
            }
            Xpp3Dom dependencyDom = new Xpp3Dom(DEPENDENCY_FIELD);
            additionalDependenciesDom.addChild(dependencyDom);
            Xpp3Dom groupIdDom = new Xpp3Dom(GROUP_ID);
            groupIdDom.setValue(descriptor.getGroupId());
            dependencyDom.addChild(groupIdDom);
            Xpp3Dom artifactIdDom = new Xpp3Dom(ARTIFACT_ID);
            artifactIdDom.setValue(descriptor.getArtifactId());
            dependencyDom.addChild(artifactIdDom);
            Xpp3Dom versionDom = new Xpp3Dom(VERSION_FIELD);
            versionDom.setValue(descriptor.getVersion());
            dependencyDom.addChild(versionDom);
        });
    }

    private Xpp3Dom createPluginDom(Xpp3Dom additionalPluginDependenciesDom, AdditionalPluginDependencies additionalPluginDependencies) {
        Xpp3Dom pluginDom = new Xpp3Dom(PLUGIN_FIELD);
        additionalPluginDependenciesDom.addChild(pluginDom);
        Xpp3Dom groupIdDom = new Xpp3Dom(GROUP_ID);
        groupIdDom.setValue(additionalPluginDependencies.getGroupId());
        pluginDom.addChild(groupIdDom);
        Xpp3Dom artifactIdDom = new Xpp3Dom(ARTIFACT_ID);
        artifactIdDom.setValue(additionalPluginDependencies.getArtifactId());
        pluginDom.addChild(artifactIdDom);
        return pluginDom;
    }

    private File createFile(String filename) throws IOException {
        File file = FileUtils.newFile(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = FileUtils.newFile(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    private File lookupPomFromMavenLocation(File artifactFolder) {
        File artifactPomFile = null;
        File lookupFolder = new File(artifactFolder, "META-INF" + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, MULE_POM);
            if (possiblePomLocation.exists()) {
                artifactPomFile = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            this.checkState(directories != null || directories.length == 0, String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            this.checkState(directories.length == 1, String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (artifactPomFile == null || !artifactPomFile.exists()) {
            throw new RuntimeException(String.format("The Maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return artifactPomFile;
    }

    private Dependency createMavenDependency(BundleDependency bundleDependency) {
        BundleDescriptor bundleDescriptor = bundleDependency.getDescriptor();
        Dependency mavenModelDependency = new Dependency();
        mavenModelDependency.setGroupId(bundleDescriptor.getGroupId());
        mavenModelDependency.setArtifactId(bundleDescriptor.getArtifactId());
        mavenModelDependency.setVersion(bundleDescriptor.getVersion());
        mavenModelDependency.setType(bundleDescriptor.getType());
        bundleDescriptor.getClassifier().ifPresent(mavenModelDependency::setClassifier);
        bundleDescriptor.getOptional().ifPresent(mavenModelDependency::setOptional);
        if (bundleDependency.getScope() != null) {
            mavenModelDependency.setScope(bundleDependency.getScope().name().toLowerCase());
        }
        bundleDescriptor.getSystemPath().ifPresent(mavenModelDependency::setSystemPath);
        mavenModelDependency.setExclusions(bundleDescriptor.getExclusions().stream().map(exclusion -> {
            Exclusion mavenModelExclusion = new Exclusion();
            mavenModelExclusion.setGroupId(exclusion.getGroupId());
            mavenModelExclusion.setArtifactId(exclusion.getArtifactId());
            return mavenModelExclusion;
        }).collect(Collectors.toList()));
        return mavenModelDependency;
    }

    private void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public class MavenProfileBuilderImpl
    implements MavenModelBuilder.MavenProfileBuilder {
        private final Profile profile = new Profile();
        private final Activation activation = new Activation();

        public MavenProfileBuilderImpl() {
            this.profile.setActivation(this.activation);
        }

        @Override
        public MavenModelBuilder.MavenProfileBuilder setActiveByDefault(boolean activeByDefault) {
            this.activation.setActiveByDefault(activeByDefault);
            return this;
        }

        @Override
        public MavenModelBuilder.MavenProfileBuilder setActivationByJdk(String jdk) {
            this.activation.setJdk(jdk);
            return this;
        }

        @Override
        public MavenModelBuilder.MavenProfileBuilder addRepository(String id, String name, String url) {
            Repository repository = new Repository();
            repository.setId(id);
            repository.setName(name);
            repository.setUrl(url);
            this.profile.addRepository(repository);
            return this;
        }

        @Override
        public MavenModelBuilder.MavenProfileBuilder addDependency(BundleDependency bundleDependency) {
            Dependency mavenDependency = MavenModelBuilderImpl.this.createMavenDependency(bundleDependency);
            this.profile.addDependency(mavenDependency);
            return this;
        }

        @Override
        public void build() {
            MavenModelBuilderImpl.this.model.addProfile(this.profile);
        }
    }
}

