/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.PropertyNotFoundException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationPropertiesResolver
implements ConfigurationPropertiesResolver,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigurationPropertiesResolver.class);
    private static final Boolean CORRECT_USE_OF_BACKSLASH = Boolean.valueOf(System.getProperty("mule.properties.correct.backslash.use", "true"));
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private final Optional<ConfigurationPropertiesResolver> nextResolver;
    private final ConfigurationPropertiesProvider configurationPropertiesProvider;
    private final Cache<String, Object> resolutionCache = CacheBuilder.newBuilder().build();
    private boolean initialized = false;
    private Optional<ConfigurationPropertiesResolver> rootResolver = Optional.empty();
    private final boolean failIfPropertyNotFound;

    public DefaultConfigurationPropertiesResolver(Optional<ConfigurationPropertiesResolver> nextResolver, ConfigurationPropertiesProvider configurationPropertiesProvider) {
        this(nextResolver, configurationPropertiesProvider, true);
    }

    public DefaultConfigurationPropertiesResolver(Optional<ConfigurationPropertiesResolver> nextResolver, ConfigurationPropertiesProvider configurationPropertiesProvider, boolean failIfPropertyNotFound) {
        this.nextResolver = nextResolver;
        this.configurationPropertiesProvider = Objects.requireNonNull(configurationPropertiesProvider);
        this.failIfPropertyNotFound = failIfPropertyNotFound;
    }

    private boolean shouldResolvePlaceholder(String value, int prefixIndex) {
        if (prefixIndex == 0) {
            return true;
        }
        if (value.charAt(prefixIndex - 1) != '\\') {
            return true;
        }
        if (prefixIndex == 1) {
            return false;
        }
        return prefixIndex <= 1 || value.charAt(prefixIndex - 2) == '\\';
    }

    private int findPrefixIndex(String value, int offset) {
        int prefixIndex = value.indexOf(PLACEHOLDER_PREFIX);
        if (prefixIndex == -1) {
            return -1;
        }
        if (this.shouldResolvePlaceholder(value, prefixIndex)) {
            return prefixIndex + offset;
        }
        int relativeOffset = prefixIndex + PLACEHOLDER_PREFIX.length();
        return this.findPrefixIndex(value.substring(relativeOffset), offset + relativeOffset);
    }

    private int findPrefixIndex(String value) {
        return this.findPrefixIndex(value, 0);
    }

    @Override
    public Object resolveValue(String value) {
        if (value == null) {
            return value;
        }
        try {
            return this.resolutionCache.get((Object)value, () -> {
                int prefixIndex = this.prefixIndexConsideringBackslash(value);
                if (prefixIndex == -1) {
                    return CORRECT_USE_OF_BACKSLASH != false ? value.replace("\\${", PLACEHOLDER_PREFIX) : value;
                }
                return this.replaceAllPlaceholders(value);
            });
        }
        catch (Exception e) {
            LOGGER.debug("Could not resolve property at {}", (Object)this.configurationPropertiesProvider.getDescription());
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failure processing configuration property " + value, e));
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.nextResolver);
        if (!this.initialized) {
            LifecycleUtils.initialiseIfNeeded(this.configurationPropertiesProvider);
            this.initialized = true;
        }
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.configurationPropertiesProvider, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.nextResolver, LOGGER);
        this.initialized = false;
    }

    @Override
    public Object resolvePlaceholderKeyValue(String placeholderKey) {
        Optional<? extends ConfigurationProperty> foundValueOptional = this.configurationPropertiesProvider.provide(placeholderKey);
        if (foundValueOptional.isPresent() && !foundValueOptional.get().getValue().equals(PLACEHOLDER_PREFIX + placeholderKey + PLACEHOLDER_SUFFIX)) {
            if (foundValueOptional.get().getValue() instanceof String) {
                return this.replaceAllPlaceholders(foundValueOptional.get().getValue());
            }
            return foundValueOptional.get();
        }
        if (this.nextResolver.isPresent()) {
            try {
                LOGGER.debug("Could not resolve property at {}, solving with next resolver", (Object)this.configurationPropertiesProvider.getDescription());
                return this.nextResolver.get().resolvePlaceholderKeyValue(placeholderKey);
            }
            catch (PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e, new Pair<String, String>(this.configurationPropertiesProvider.getDescription(), placeholderKey));
            }
        }
        LOGGER.debug("Could not resolve property at {}, and there is no next resolver", (Object)this.configurationPropertiesProvider.getDescription());
        throw new PropertyNotFoundException(new Pair<String, String>(this.configurationPropertiesProvider.getDescription(), placeholderKey));
    }

    private Object tryResolveByRoot(String placeholder) {
        if (!this.rootResolver.isPresent()) {
            return this.resolvePlaceholderKeyValue(placeholder);
        }
        try {
            return this.rootResolver.get().resolvePlaceholderKeyValue(placeholder);
        }
        catch (PropertyNotFoundException e) {
            return this.resolvePlaceholderKeyValue(placeholder);
        }
    }

    private int prefixIndexConsideringBackslash(String value) {
        return CORRECT_USE_OF_BACKSLASH != false ? this.findPrefixIndex(value) : value.indexOf(PLACEHOLDER_PREFIX);
    }

    private Object replaceAllPlaceholders(String value) {
        String testValue = value;
        int prefixIndex = this.prefixIndexConsideringBackslash(value);
        while (prefixIndex != -1) {
            int suffixIndex = testValue.indexOf(PLACEHOLDER_SUFFIX, prefixIndex + PLACEHOLDER_PREFIX.length());
            String innerPlaceholderKey = testValue.substring(prefixIndex + PLACEHOLDER_PREFIX.length(), suffixIndex);
            Object objectValueFound = this.tryResolveByRoot(innerPlaceholderKey);
            if (value.equals(PLACEHOLDER_PREFIX + innerPlaceholderKey + PLACEHOLDER_SUFFIX)) {
                return objectValueFound;
            }
            if (prefixIndex > 1 && testValue.charAt(prefixIndex - 1) == '\\' && testValue.charAt(prefixIndex - 2) == '\\') {
                --prefixIndex;
            }
            testValue = testValue.substring(0, prefixIndex) + objectValueFound.toString() + testValue.substring(suffixIndex + 1);
            prefixIndex = this.prefixIndexConsideringBackslash(testValue);
        }
        return CORRECT_USE_OF_BACKSLASH != false ? testValue.replace("\\${", PLACEHOLDER_PREFIX) : testValue;
    }

    private void propagateRootResolver(ConfigurationPropertiesResolver rootResolver) {
        this.nextResolver.ifPresent(resolver -> {
            if (resolver instanceof DefaultConfigurationPropertiesResolver) {
                ((DefaultConfigurationPropertiesResolver)resolver).setRootResolver(rootResolver);
            }
        });
    }

    public void setRootResolver(ConfigurationPropertiesResolver rootResolver) {
        this.rootResolver = Optional.of(rootResolver);
        this.propagateRootResolver(rootResolver);
    }

    public void setAsRootResolver() {
        this.propagateRootResolver(this);
    }

    @Override
    public String apply(String t) {
        try {
            Object resolved = this.resolveValue(t);
            return resolved == null ? null : resolved.toString();
        }
        catch (PropertyNotFoundException p) {
            if (this.failIfPropertyNotFound) {
                throw p;
            }
            return t;
        }
    }

    public String toString() {
        return this.configurationPropertiesProvider.toString() + this.nextResolver.map(n -> " -> " + n.toString()).orElse("");
    }
}

