/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Type;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.meta.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsIntrospectorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationsIntrospectorUtils.class);

    public static Map<Class<? extends Annotation>, Annotation> extractAnnotations(final Class<?> clazz) {
        final ArrayList annotations = new ArrayList();
        try (InputStream classStream = AnnotationsIntrospectorUtils.getClassAsStream(clazz);){
            ClassReader classReader = new ClassReader(classStream);
            final int asmLevel = 327680;
            classReader.accept(new ClassVisitor(asmLevel){

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return AnnotationsIntrospectorUtils.getAnnotationVisitor(descriptor, asmLevel, annotations, clazz.getClassLoader());
                }
            }, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return annotations.stream().collect(Collectors.toMap(annotation -> ((Annotation)annotation).annotationType(), annotation -> (Annotation)annotation));
    }

    private static AnnotationVisitor getAnnotationVisitor(String descriptor, int asmLevel, List<Object> annotations, ClassLoader classLoader) {
        String annotationClassName = AnnotationsIntrospectorUtils.descriptorToClassName(descriptor);
        try {
            Class<?> annotationClass = classLoader.loadClass(annotationClassName);
            return AnnotationsIntrospectorUtils.getAnnotationVisitor(annotationClass, asmLevel, annotations, false, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unexpected error while parsing annotation '%s'", annotationClassName), e);
        }
    }

    private static AnnotationVisitor getAnnotationVisitor(final Class<? extends Annotation> annotationClass, final int asmLevel, final List<Object> values, final boolean isArray, final ClassLoader classLoader) {
        final HashMap annotationValues = new HashMap();
        return new AnnotationVisitor(asmLevel){

            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                return AnnotationsIntrospectorUtils.getAnnotationVisitor(descriptor, asmLevel, values, classLoader);
            }

            public void visit(String name, Object value) {
                Class<?> processedValue = value;
                if (value instanceof Type) {
                    Type type = (Type)value;
                    try {
                        processedValue = classLoader.loadClass(type.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (isArray) {
                    values.add(processedValue);
                } else {
                    annotationValues.put(name, processedValue);
                }
            }

            public void visitEnum(String name, String descriptor, String value) {
                String enumClassName = AnnotationsIntrospectorUtils.descriptorToClassName(descriptor);
                try {
                    Class<?> enumClass = classLoader.loadClass(enumClassName);
                    Object enumValue = Enum.valueOf(enumClass, value);
                    if (isArray) {
                        values.add(enumValue);
                    } else {
                        annotationValues.put(name, enumValue);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!enumClassName.equals("org.mule.sdk.api.annotation.JavaVersionSupport")) {
                        LOGGER.warn("Error while loading value '{}' for Enum '{}'", (Object)value, (Object)enumClassName);
                    }
                    LOGGER.debug("Invalid JavaVersionSupport value: '{}'", (Object)value);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Unexpected error while parsing Enum '%s'", enumClassName), e);
                }
            }

            public AnnotationVisitor visitArray(String name) {
                ArrayList arrayValues = new ArrayList();
                annotationValues.put(name, arrayValues);
                return AnnotationsIntrospectorUtils.getAnnotationVisitor(annotationClass, asmLevel, arrayValues, true, classLoader);
            }

            public void visitEnd() {
                if (!isArray) {
                    Arrays.stream(annotationClass.getDeclaredMethods()).filter(method -> annotationValues.keySet().stream().noneMatch(valueName -> valueName.equals(method.getName()))).forEach(method -> annotationValues.put(method.getName(), method.getDefaultValue()));
                    annotationValues.forEach((key, value) -> {
                        if (value instanceof List) {
                            Class<?> componentType;
                            List list = (List)value;
                            try {
                                componentType = annotationClass.getDeclaredMethod((String)key, new Class[0]).getReturnType().getComponentType();
                            }
                            catch (NoSuchMethodException e) {
                                throw new RuntimeException(e);
                            }
                            Object typedArray = Array.newInstance(componentType, list.size());
                            for (int i = 0; i < list.size(); ++i) {
                                Array.set(typedArray, i, list.get(i));
                            }
                            annotationValues.put(key, typedArray);
                        }
                    });
                    values.add(AnnotationsIntrospectorUtils.createAnnotationProxy(annotationClass, annotationValues));
                }
            }
        };
    }

    public static JavaVersion[] extractJavaVersionValues(Class<?> clazz) throws Exception {
        try (InputStream classStream = AnnotationsIntrospectorUtils.getClassAsStream(clazz);){
            final ArrayList javaVersions = new ArrayList();
            ClassReader reader = new ClassReader(classStream);
            final int asmVersion = 327680;
            reader.accept(new ClassVisitor(asmVersion){

                public AnnotationVisitor visitAnnotation(final String descriptor, boolean visible) {
                    return new AnnotationVisitor(asmVersion){

                        public AnnotationVisitor visitArray(String name) {
                            return new AnnotationVisitor(asmVersion){

                                public void visitEnum(String name, String desc, String value) {
                                    try {
                                        if (descriptor.endsWith(JavaVersionSupport.class.getSimpleName() + ";")) {
                                            javaVersions.add(JavaVersion.valueOf(value));
                                        }
                                    }
                                    catch (IllegalArgumentException e) {
                                        LOGGER.debug("Found unknown value '{}' in JavaVersionSupport annotation", (Object)value, (Object)e);
                                    }
                                }
                            };
                        }
                    };
                }
            }, 0);
            JavaVersion[] javaVersionArray = javaVersions.toArray(new JavaVersion[javaVersions.size()]);
            return javaVersionArray;
        }
    }

    private static InputStream getClassAsStream(Class<?> clazz) {
        String className = clazz.getName().replace('.', '/') + ".class";
        InputStream classStream = clazz.getClassLoader().getResourceAsStream(className);
        if (classStream == null) {
            throw new RuntimeException(String.format("Unable to load extension class '%s' from class loader '%s'", className, clazz.getClassLoader()));
        }
        return classStream;
    }

    private static String descriptorToClassName(String descriptor) {
        if (descriptor.startsWith("L") && descriptor.endsWith(";")) {
            return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
        }
        switch (descriptor) {
            case "I": {
                return "int";
            }
            case "Z": {
                return "boolean";
            }
            case "B": {
                return "byte";
            }
            case "C": {
                return "char";
            }
            case "S": {
                return "short";
            }
            case "J": {
                return "long";
            }
            case "F": {
                return "float";
            }
            case "D": {
                return "double";
            }
        }
        return descriptor;
    }

    private static <A extends Annotation> A createAnnotationProxy(Class<A> annotationClass, Map<String, Object> values) {
        return (A)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new CustomAnnotationInvocationHandler(annotationClass, values)));
    }

    private static class CustomAnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<? extends Annotation> annotationType;
        private final Map<String, Object> memberValues;

        public CustomAnnotationInvocationHandler(Class<? extends Annotation> annotationType, Map<String, Object> memberValues) {
            this.annotationType = annotationType;
            this.memberValues = memberValues;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String methodName;
            switch (methodName = method.getName()) {
                case "equals": {
                    return this.annotationEquals(args[0]);
                }
                case "hashCode": {
                    return this.annotationHashCode();
                }
                case "toString": {
                    return this.annotationToString();
                }
                case "annotationType": {
                    return this.annotationType;
                }
            }
            Object value = this.memberValues.get(methodName);
            return value != null ? value : method.getDefaultValue();
        }

        private boolean annotationEquals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.annotationType.isInstance(obj)) {
                return false;
            }
            for (Method method : this.annotationType.getDeclaredMethods()) {
                if (method.getParameterCount() != 0) continue;
                try {
                    Object thisValue = this.memberValues.get(method.getName());
                    Object otherValue = method.invoke(obj, new Object[0]);
                    if (this.deepEquals(thisValue, otherValue)) continue;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }

        private boolean deepEquals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (o1.getClass().isArray() && o2.getClass().isArray()) {
                return Arrays.deepEquals((Object[])o1, (Object[])o2);
            }
            return o1.equals(o2);
        }

        public int annotationHashCode() {
            int result = 0;
            for (Map.Entry<String, Object> entry : this.memberValues.entrySet()) {
                result += 127 * entry.getKey().hashCode() ^ (entry.getValue() != null ? entry.getValue().hashCode() : 0);
            }
            return result;
        }

        public String annotationToString() {
            StringBuilder sb = new StringBuilder("@");
            sb.append(this.annotationType.getName()).append("(");
            boolean first = true;
            boolean loneValue = this.memberValues.size() == 1;
            for (Map.Entry<String, Object> entry : this.memberValues.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                String key = entry.getKey();
                if (!loneValue || !"value".equals(key)) {
                    sb.append(key).append('=');
                }
                sb.append(this.memberValueToString(entry.getValue()));
                first = false;
            }
            sb.append(")");
            return sb.toString();
        }

        private String memberValueToString(Object value) {
            return value.getClass().isArray() ? Arrays.stream((Object[])value).map(Object::toString).collect(Collectors.joining(", ", "{", "}")) : value.toString();
        }
    }
}

