/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.el.DefaultBindingContextBuilder;
import org.mule.runtime.core.internal.el.DefaultExpressionModuleBuilder;
import org.mule.runtime.core.internal.transformer.simple.StringToEnum;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.module.extension.internal.lifecycle.ExtensionOnMuleContextDisposedNotificationListener;
import org.mule.runtime.module.extension.internal.loader.java.property.FunctionExecutorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutor;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionParameterDefaultValueResolverFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ExtensionActivator
implements Startable,
Stoppable {
    private final MuleContext muleContext;
    private final Set<Class<? extends Enum>> enumTypes = new HashSet<Class<? extends Enum>>();
    private final List<Object> lifecycleAwareElements = new LinkedList<Object>();

    ExtensionActivator(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    void activateExtension(ExtensionModel extensionModel) {
        this.registerEnumTransformers(extensionModel);
        this.registerAsModuleDefinition(extensionModel);
        ExtensionOnMuleContextDisposedNotificationListener.registerLifecycleListenerForOnContextDisposed(this.muleContext.getNotificationManager(), this.muleContext.getExecutionClassLoader(), extensionModel);
    }

    private void registerEnumTransformers(ExtensionModel extensionModel) {
        ClassLoader classLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        HashSet parameterClasses = new HashSet();
        parameterClasses.addAll(IntrospectionUtils.getParameterClasses(extensionModel, classLoader));
        parameterClasses.addAll(IntrospectionUtils.getSubtypeClasses(extensionModel, classLoader));
        parameterClasses.stream().filter(type -> Enum.class.isAssignableFrom((Class<?>)type)).forEach(type -> {
            Class enumClass = type;
            if (this.enumTypes.add(enumClass)) {
                try {
                    StringToEnum stringToEnum = new StringToEnum(enumClass);
                    LegacyRegistryUtils.registerObject(this.muleContext, stringToEnum.getName(), stringToEnum);
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not register transformer for enum " + enumClass.getName()), (Throwable)e);
                }
            }
        });
    }

    private void registerAsModuleDefinition(ExtensionModel extensionModel) {
        if (extensionModel.getFunctionModels().isEmpty() && extensionModel.getTypes().isEmpty()) {
            return;
        }
        ExpressionModule expressionModule = this.extensionAsModuleDefinition(extensionModel);
        try {
            BindingContext bindingContext = new DefaultBindingContextBuilder().addModule(expressionModule).build();
            LegacyRegistryUtils.registerObject(this.muleContext, extensionModel.getName() + "GlobalBindingContextProvider", () -> bindingContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(e.getMessage()), (Throwable)e);
        }
    }

    private ExpressionModule extensionAsModuleDefinition(ExtensionModel extensionModel) {
        ModuleNamespace namespace = new ModuleNamespace(extensionModel.getXmlDslModel().getPrefix());
        DefaultExpressionModuleBuilder moduleBuilder = new DefaultExpressionModuleBuilder(namespace);
        if (!extensionModel.getFunctionModels().isEmpty()) {
            this.addExtensionFunctions(extensionModel.getFunctionModels().stream(), moduleBuilder);
        }
        if (!extensionModel.getTypes().isEmpty()) {
            this.addExtensionTypes(extensionModel.getTypes().stream(), moduleBuilder);
        }
        return moduleBuilder.build();
    }

    private void addExtensionTypes(Stream<ObjectType> objectTypes, ExpressionModule.Builder module) {
        objectTypes.forEach(module::addType);
    }

    private void addExtensionFunctions(Stream<FunctionModel> functions, ExpressionModule.Builder module) {
        FunctionParameterDefaultValueResolverFactory valueResolverFactory = (defaultValue, type) -> context -> {
            String value;
            ExtendedExpressionManager em = this.muleContext.getExpressionManager();
            return em.isExpression(value = String.valueOf(defaultValue)) ? em.evaluate(value, type, context) : new TypedValue((Object)defaultValue, type);
        };
        functions.forEach(function -> function.getModelProperty(FunctionExecutorModelProperty.class).ifPresent(mp -> {
            FunctionExecutor executor = mp.getExecutorFactory().createExecutor((FunctionModel)function, valueResolverFactory);
            this.lifecycleAwareElements.add(executor);
            module.addBinding(function.getName(), new TypedValue<FunctionExecutor>(executor, DataType.fromFunction(executor)));
        }));
    }

    @Override
    public void start() throws MuleException {
        for (Object element : this.lifecycleAwareElements) {
            LifecycleUtils.initialiseIfNeeded(element, this.muleContext);
            LifecycleUtils.startIfNeeded(element);
        }
    }

    @Override
    public void stop() throws MuleException {
        for (Object element : this.lifecycleAwareElements) {
            LifecycleUtils.stopIfNeeded(element);
        }
        this.lifecycleAwareElements.clear();
        this.enumTypes.clear();
    }

    public Set<Class<? extends Enum>> getEnumTypes() {
        return this.enumTypes;
    }
}

