/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.GeneratedMethodComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.CompletableSourceCompletionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;

class DefaultSourceCallbackExecutor
implements SourceCallbackExecutor {
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final SourceModel sourceModel;
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final MuleContext muleContext;
    private final boolean async;
    private final GeneratedMethodComponentExecutor<SourceModel> executor;
    private final Component component;

    public DefaultSourceCallbackExecutor(ExtensionModel extensionModel, Optional<ConfigurationInstance> configurationInstance, SourceModel sourceModel, Object source, Method method, CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, Component component, MuleContext muleContext, SourceCallbackModelProperty sourceCallbackModel) {
        this.extensionModel = extensionModel;
        this.configurationInstance = configurationInstance;
        this.sourceModel = sourceModel;
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.component = component;
        this.muleContext = muleContext;
        this.executor = new GeneratedMethodComponentExecutor(this.getAllGroups(sourceModel, method, sourceCallbackModel), method, source);
        try {
            LifecycleUtils.initialiseIfNeeded(this.executor, true, muleContext);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(e);
        }
        this.async = Stream.of(method.getParameterTypes()).anyMatch(MuleExtensionUtils::isSourceCompletionCallbackType);
    }

    @Override
    public void execute(CoreEvent event, Map<String, Object> parameters, SourceCallbackContext context, CompletableCallback<Void> callback) {
        if (this.async) {
            ExecutionContext<SourceModel> executionContext = this.createExecutionContext(event, parameters, context, new CompletableSourceCompletionCallback(callback));
            try {
                this.executor.execute(executionContext);
            }
            catch (Throwable t) {
                callback.error(Exceptions.wrapFatal(t));
            }
        } else {
            try {
                this.executor.execute(this.createExecutionContext(event, parameters, context, null));
                callback.complete(null);
            }
            catch (Throwable t) {
                callback.error(Exceptions.wrapFatal(t));
            }
        }
    }

    private ExecutionContext<SourceModel> createExecutionContext(CoreEvent event, Map<String, Object> parameters, SourceCallbackContext callbackContext, SourceCompletionCallback sourceCompletionCallback) {
        DefaultExecutionContext<SourceModel> executionContext = new DefaultExecutionContext<SourceModel>(this.extensionModel, this.configurationInstance, parameters, this.sourceModel, event, this.cursorProviderFactory, this.streamingManager, this.component, null, ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), this.muleContext);
        executionContext.setVariable("MULE_SOURCE_CALLBACK_CONTEXT_PARAM", callbackContext);
        if (sourceCompletionCallback != null) {
            executionContext.setVariable("MULE_SOURCE_COMPLETION_CALLBACK_PARAM", sourceCompletionCallback);
        }
        callbackContext.getVariable("MULE_BACK_PRESSURE_ACTION_CONTEXT_PARAM").ifPresent(action -> executionContext.setVariable("MULE_BACK_PRESSURE_ACTION_CONTEXT_PARAM", action));
        return executionContext;
    }

    private List<ParameterGroupModel> getAllGroups(SourceModel model, Method method, SourceCallbackModelProperty sourceCallbackModel) {
        List callbackParameters = sourceCallbackModel.getOnSuccessMethod().filter(method::equals).map(m -> this.sourceModel.getSuccessCallback().get().getParameterGroupModels()).orElseGet(() -> sourceCallbackModel.getOnErrorMethod().filter(method::equals).map(m -> this.sourceModel.getErrorCallback().get().getParameterGroupModels()).orElseGet(() -> this.sourceModel.getTerminateCallback().get().getParameterGroupModels()));
        return ImmutableList.builder().addAll(model.getParameterGroupModels()).addAll((Iterable)callbackParameters).build();
    }
}

