/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.EnumerationAdapter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.BlockingLoggerResolutionClassRegistry;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;
import org.mule.runtime.module.artifact.api.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.api.classloader.exception.NotExportedClassException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public class FilteringArtifactClassLoader
extends ClassLoader
implements ArtifactClassLoader {
    private static final Logger LOGGER;
    private static final String SERVICE_PREFIX = "META-INF/services/";
    private final ArtifactClassLoader artifactClassLoader;
    private final ClassLoaderFilter filter;
    private final List<ExportedService> exportedServices;
    private Optional<ModuleLayerInformationSupplier> moduleLayerInformation = Optional.empty();
    private final boolean verboseLogging;

    public FilteringArtifactClassLoader(ClassLoader parent, ArtifactClassLoader artifactClassLoader, ClassLoaderFilter filter, List<ExportedService> exportedServices) {
        super(parent);
        Preconditions.checkArgument(artifactClassLoader != null, "ArtifactClassLoader cannot be null");
        Preconditions.checkArgument(filter != null, "Filter cannot be null");
        Preconditions.checkArgument(exportedServices != null, "exportedServiceProviders cannot be null");
        this.artifactClassLoader = artifactClassLoader;
        this.filter = filter;
        this.exportedServices = exportedServices;
        this.verboseLogging = Boolean.valueOf(System.getProperty("mule.classloading.verbose"));
    }

    private boolean isVerboseLogging() {
        return this.verboseLogging && LOGGER.isDebugEnabled();
    }

    public FilteringArtifactClassLoader(ArtifactClassLoader artifactClassLoader, ClassLoaderFilter filter, List<ExportedService> exportedServices) {
        this(FilteringArtifactClassLoader.getSystemClassLoader(), artifactClassLoader, filter, exportedServices);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.filter.exportsClass(name)) {
            return this.artifactClassLoader.getClassLoader().loadClass(name);
        }
        throw new NotExportedClassException(name, this.getArtifactId(), this.filter);
    }

    @Override
    public URL getResource(String name) {
        if (this.isServiceResource(name)) {
            Optional<ExportedService> exportedService = this.getExportedServiceStream(name).findFirst();
            if (exportedService.isPresent()) {
                if (this.isVerboseLogging()) {
                    this.logClassloadingTrace(String.format("Service resource '%s' found in classloader for '%s': '%s", name, this.getArtifactId(), exportedService.get()));
                }
                return exportedService.get().getResource();
            }
            if (this.isVerboseLogging()) {
                this.logClassloadingTrace(String.format("Service resource '%s' not found in classloader for '%s'.", name, this.getArtifactId()));
            }
            return null;
        }
        if (this.filter.exportsResource(name)) {
            return this.getResourceFromDelegate(this.artifactClassLoader, name);
        }
        if (this.isVerboseLogging()) {
            this.logClassloadingTrace(String.format("Resource '%s' not found in classloader for '%s'.", name, this.getArtifactId()));
            this.logClassloadingTrace(String.format("Filter applied for resource '%s': %s", name, this.getArtifactId()));
        }
        return null;
    }

    protected URL getResourceFromDelegate(ArtifactClassLoader artifactClassLoader, String name) {
        return artifactClassLoader.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isServiceResource(name)) {
            List exportedServiceProviders = this.getExportedServiceStream(name).map(s -> s.getResource()).collect(Collectors.toList());
            if (this.isVerboseLogging()) {
                if (exportedServiceProviders.isEmpty()) {
                    this.logClassloadingTrace(String.format("Service resource '%s' not found in classloader for '%s'.", name, this.getArtifactId()));
                } else {
                    this.logClassloadingTrace(String.format("Service resources '%s' found in classloader for '%s': '%s", name, this.getArtifactId(), exportedServiceProviders));
                }
            }
            return new EnumerationAdapter<URL>(exportedServiceProviders);
        }
        if (this.filter.exportsResource(name)) {
            return this.getResourcesFromDelegate(this.artifactClassLoader, name);
        }
        if (this.isVerboseLogging()) {
            this.logClassloadingTrace(String.format("Resources '%s' not found in classloader for '%s'.", name, this.getArtifactId()));
            this.logClassloadingTrace(String.format("Filter applied for resources '%s': %s", name, this.getArtifactId()));
        }
        return new EnumerationAdapter<URL>(Collections.emptyList());
    }

    private Stream<ExportedService> getExportedServiceStream(String name) {
        String serviceInterface = this.getServiceInterfaceFromResource(name);
        return this.exportedServices.stream().filter(s -> serviceInterface.equals(s.getServiceInterface()));
    }

    private String getServiceInterfaceFromResource(String name) {
        return name.substring(SERVICE_PREFIX.length());
    }

    private boolean isServiceResource(String name) {
        return name.startsWith(SERVICE_PREFIX);
    }

    private void logClassloadingTrace(String message) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(message);
        } else {
            LOGGER.info(message);
        }
    }

    protected Enumeration<URL> getResourcesFromDelegate(ArtifactClassLoader artifactClassLoader, String name) throws IOException {
        return artifactClassLoader.findResources(name);
    }

    @Override
    public URL findResource(String name) {
        return this.artifactClassLoader.findResource(name);
    }

    @Override
    public URL findInternalResource(String resource) {
        return this.findResource(resource);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.artifactClassLoader.findResources(name);
    }

    @Override
    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        return this.artifactClassLoader.findLocalClass(name);
    }

    @Override
    protected Package getPackage(String name) {
        return this.filter.exportsPackage(name) ? super.getPackage(name) : null;
    }

    @Override
    protected Package[] getPackages() {
        Package[] packagesList = super.getPackages();
        return (Package[])Arrays.stream(packagesList).filter(aPackage -> this.filter.exportsPackage(aPackage.getName())).toArray(Package[]::new);
    }

    @Override
    public Class<?> loadInternalClass(String name) throws ClassNotFoundException {
        return this.artifactClassLoader.getClassLoader().loadClass(name);
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.artifactClassLoader.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public String getArtifactId() {
        return this.artifactClassLoader.getArtifactId();
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return this.artifactClassLoader.getArtifactDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.artifactClassLoader.addShutdownListener(listener);
    }

    @Override
    public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
        return this.artifactClassLoader.getClassLoaderLookupPolicy();
    }

    @Override
    public void dispose() {
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.artifactClassLoader.findLocalResource(resourceName);
    }

    public ArtifactClassLoader getArtifactClassLoader() {
        return this.artifactClassLoader;
    }

    @Override
    public void setModuleLayerInformationSupplier(ModuleLayerInformationSupplier moduleLayerInformationSupplier) {
        this.moduleLayerInformation = Optional.of(moduleLayerInformationSupplier);
    }

    @Override
    public Optional<ModuleLayerInformationSupplier> getModuleLayerInformation() {
        return this.moduleLayerInformation;
    }

    static {
        FilteringArtifactClassLoader.registerAsParallelCapable();
        BlockingLoggerResolutionClassRegistry.getBlockingLoggerResolutionClassRegistry().registerClassNeedingBlockingLoggerResolution(FilteringArtifactClassLoader.class);
        LOGGER = LoggerFactory.getLogger(FilteringArtifactClassLoader.class);
    }
}

