/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.module.launcher.coreextension.LinkedMuleCoreExtensionDependency;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyDiscoverer;
import org.mule.runtime.module.launcher.coreextension.UnresolveableDependencyException;

public class ReflectionMuleCoreExtensionDependencyResolver
implements MuleCoreExtensionDependencyResolver {
    private final MuleCoreExtensionDependencyDiscoverer dependencyDiscoverer;

    public ReflectionMuleCoreExtensionDependencyResolver() {
        this(new ReflectionMuleCoreExtensionDependencyDiscoverer());
    }

    public ReflectionMuleCoreExtensionDependencyResolver(MuleCoreExtensionDependencyDiscoverer dependencyDiscoverer) {
        this.dependencyDiscoverer = dependencyDiscoverer;
    }

    @Override
    public List<MuleCoreExtension> resolveDependencies(Collection<MuleCoreExtension> coreExtensions) {
        LinkedList<MuleCoreExtension> sortedCoreExtensions = new LinkedList<MuleCoreExtension>(coreExtensions);
        this.sortCoreExtensionsByName(sortedCoreExtensions);
        List<MuleCoreExtension> coreExtensionAwareExtensions = this.findCoreExtensionAwareExtensions(sortedCoreExtensions);
        sortedCoreExtensions.removeAll(coreExtensionAwareExtensions);
        List<MuleCoreExtension> resolvedExtensions = this.resolveCoreExtensionDependenciesOrder(sortedCoreExtensions);
        resolvedExtensions.addAll(coreExtensionAwareExtensions);
        return resolvedExtensions;
    }

    private List<MuleCoreExtension> resolveCoreExtensionDependenciesOrder(List<MuleCoreExtension> sortedCoreExtensions) {
        LinkedList<MuleCoreExtension> unresolvedExtensions = new LinkedList<MuleCoreExtension>(sortedCoreExtensions);
        LinkedList<MuleCoreExtension> resolvedExtensions = new LinkedList<MuleCoreExtension>();
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedExtensions.size();
            LinkedList<MuleCoreExtension> pendingUnresolvedExtensions = new LinkedList<MuleCoreExtension>();
            for (MuleCoreExtension muleCoreExtension : unresolvedExtensions) {
                if (this.isResolvedCoreExtension(muleCoreExtension, resolvedExtensions)) {
                    resolvedExtensions.add(muleCoreExtension);
                    continue;
                }
                pendingUnresolvedExtensions.add(muleCoreExtension);
            }
            unresolvedExtensions = pendingUnresolvedExtensions;
            continueResolution = resolvedExtensions.size() > initialResolvedCount;
        }
        if (unresolvedExtensions.size() != 0) {
            throw new UnresolveableDependencyException("Unable to resolve core extension dependencies: " + unresolvedExtensions);
        }
        return resolvedExtensions;
    }

    private boolean isResolvedCoreExtension(MuleCoreExtension muleCoreExtension, List<MuleCoreExtension> resolvedExtensions) {
        boolean resolvedCoreExtension;
        List<LinkedMuleCoreExtensionDependency> dependencies = this.dependencyDiscoverer.findDependencies(muleCoreExtension);
        boolean bl = resolvedCoreExtension = dependencies.size() == 0;
        if (!resolvedCoreExtension && this.satisfiedDependencies(dependencies, resolvedExtensions)) {
            this.injectDependencies(muleCoreExtension, resolvedExtensions, dependencies);
            resolvedCoreExtension = true;
        }
        return resolvedCoreExtension;
    }

    private List<MuleCoreExtension> findCoreExtensionAwareExtensions(List<MuleCoreExtension> sortedCoreExtensions) {
        LinkedList<MuleCoreExtension> coreExtensionAwareExtensions = new LinkedList<MuleCoreExtension>();
        for (MuleCoreExtension muleCoreExtension : sortedCoreExtensions) {
            if (!(muleCoreExtension instanceof CoreExtensionsAware)) continue;
            List<LinkedMuleCoreExtensionDependency> dependencies = this.dependencyDiscoverer.findDependencies(muleCoreExtension);
            if (dependencies.isEmpty()) {
                coreExtensionAwareExtensions.add(muleCoreExtension);
                continue;
            }
            throw new IllegalDependencyInjectionException("A class cannot implement CoreExtensionAware when is also using MuleCoreExtensionDependency");
        }
        return coreExtensionAwareExtensions;
    }

    private void sortCoreExtensionsByName(List<MuleCoreExtension> coreExtensionAwareExtensions1) {
        Collections.sort(coreExtensionAwareExtensions1, new Comparator<MuleCoreExtension>(){

            @Override
            public int compare(MuleCoreExtension coreExtension1, MuleCoreExtension coreExtension2) {
                return coreExtension1.getName().compareTo(coreExtension2.getName());
            }
        });
    }

    private void injectDependencies(MuleCoreExtension muleCoreExtension, List<MuleCoreExtension> resolvedExtensions, List<LinkedMuleCoreExtensionDependency> dependencies) {
        for (LinkedMuleCoreExtensionDependency linkedMuleCoreExtensionDependency : dependencies) {
            MuleCoreExtension dependencyInstance = this.findDependencyInstance(resolvedExtensions, linkedMuleCoreExtensionDependency.getDependencyClass());
            try {
                linkedMuleCoreExtensionDependency.getDependantMethod().invoke((Object)muleCoreExtension, dependencyInstance);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
    }

    private MuleCoreExtension findDependencyInstance(List<MuleCoreExtension> resolvedExtensions, Class<? extends MuleCoreExtension> dependencyClass) {
        for (MuleCoreExtension coreExtension : resolvedExtensions) {
            if (!dependencyClass.isAssignableFrom(coreExtension.getClass())) continue;
            return coreExtension;
        }
        throw new IllegalArgumentException("Unable to find an instance for " + dependencyClass);
    }

    private boolean satisfiedDependencies(List<LinkedMuleCoreExtensionDependency> dependencies, List<MuleCoreExtension> resolvedExtensions) {
        for (LinkedMuleCoreExtensionDependency dependency : dependencies) {
            boolean isResolved = false;
            for (MuleCoreExtension resolved : resolvedExtensions) {
                if (!dependency.getDependencyClass().isAssignableFrom(resolved.getClass())) continue;
                isResolved = true;
            }
            if (isResolved) continue;
            return false;
        }
        return true;
    }
}

