/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.builders;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.RegistryBootstrap;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectivityTesterFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.core.internal.profiling.EmptySpanExporterConfiguration;
import org.mule.runtime.core.internal.profiling.NoOpProfilingService;
import org.mule.runtime.core.internal.profiling.NoopCoreEventTracer;
import org.mule.runtime.core.internal.profiling.NoopSpanExporterFactory;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DefaultTransformersRegistry;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.runtime.tracer.api.EventTracer;

public class MinimalConfigurationBuilder
extends AbstractConfigurationBuilder {
    private final Set<String> registeredServices = new HashSet<String>();

    @Override
    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
        RegistryBootstrap.defaultRegistryBoostrap(ArtifactType.APP, muleContext).initialise();
        this.configureQueueManager(muleContext);
        registry.registerObject("_muleContext", muleContext);
        this.registerCustomServices(muleContext);
        this.registerObjectStoreManager(muleContext);
        this.registerSchedulerPoolsConfig(muleContext);
        this.registerLockFactory(muleContext);
        this.registerTransformerRegistry(muleContext);
        this.registerExpressionManager(muleContext, registry);
        this.registerConnectionManager(muleContext);
        this.registerNotificationHandlingObjects(muleContext);
        this.registerConnectivityTester(muleContext);
        this.registerInterceptionApiObjects(muleContext);
        this.registerObject("_muleSecurityManager", new DefaultMuleSecurityManager(), muleContext);
        this.registerObject("_muleStreamCloserService", new DefaultStreamCloserService(), muleContext);
        this.registerObject("_muleDefaultObjectSerializer", new JavaObjectSerializer(), muleContext);
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerObject(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository, muleContext);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(contributedErrorTypeRepository));
        this.registerObject(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator, muleContext);
        this.tryRegisterMvel(muleContext);
        this.registerObject("_muleStreamingGhostBuster", new StreamingGhostBuster(), muleContext);
        this.registerStreamingManager(muleContext);
        this.registerObject("_muleTimeSupplier", new LocalTimeSupplier(), muleContext);
        this.registerObject("_muleClusterService", new DefaultClusterService(), muleContext);
        this.registerTransactionFactoryLocator(muleContext);
        if (((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_muleProfilingService") == null) {
            this.registerObject("_muleProfilingService", new NoOpProfilingService(), muleContext);
        }
        this.configureCoreTracer(muleContext);
        this.configureComponentTracerFactory(muleContext);
        this.configureSpanExporterConfiguration(muleContext);
        this.configureSpanExporterFactory(muleContext);
        this.registerObject("_muleComponentInitialStateManager", new ComponentInitialStateManager(){

            @Override
            public boolean mustStartMessageSource(Component component) {
                return true;
            }
        }, muleContext);
        this.registerObject("_muleResourceLocator", new DefaultResourceLocator(), muleContext);
        for (String serviceId : ((InternalCustomizationService)muleContext.getCustomizationService()).getDefaultServices().keySet()) {
            if (this.registeredServices.contains(serviceId)) continue;
            this.registerObject(serviceId, null, muleContext);
        }
    }

    protected void registerTransactionFactoryLocator(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleTransactionFactoryLocator", new TransactionFactoryLocator(), muleContext);
    }

    protected void registerStreamingManager(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleStreamingManager", new DefaultStreamingManager(), muleContext);
    }

    protected void registerInterceptionApiObjects(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleInterceptorManager", new DefaultProcessorInterceptorManager(), muleContext);
    }

    protected void registerConnectivityTester(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleConnectivityTesterFactory", new DefaultConnectivityTesterFactory(), muleContext);
    }

    protected void registerConnectionManager(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleConnectionManager", new DefaultConnectionManager(muleContext), muleContext);
    }

    protected void registerNotificationHandlingObjects(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleNotificationDispatcher", new DefaultNotificationDispatcher(), muleContext);
        this.registerObject("_muleNotificationListenerRegistry", new DefaultNotificationListenerRegistry(), muleContext);
    }

    protected void registerExpressionManager(MuleContext muleContext, MuleRegistry registry) throws MuleException {
        this.registerObject("_muleExpressionManager", this.getExpressionManager(muleContext, registry), muleContext);
    }

    protected ExtendedExpressionManager getExpressionManager(MuleContext muleContext, MuleRegistry registry) throws MuleException {
        DefaultExpressionManager expressionManager = new DefaultExpressionManager();
        DefaultExpressionLanguageFactoryService service = this.getExpressionLanguageFactoryService(registry);
        expressionManager.setExpressionLanguage(new DataWeaveExpressionLanguageAdaptor(muleContext, null, service, null));
        muleContext.getInjector().inject(expressionManager);
        return expressionManager;
    }

    protected DefaultExpressionLanguageFactoryService getExpressionLanguageFactoryService(MuleRegistry registry) throws RegistrationException {
        return registry.lookupObject(DefaultExpressionLanguageFactoryService.class);
    }

    protected void tryRegisterMvel(MuleContext muleContext) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, RegistrationException {
        try {
            Class<?> mvelLangCls = Class.forName("org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage");
            mvelLangCls.getConstructor(MuleContext.class).newInstance(muleContext);
            this.registerObject("_muleExpressionLanguage", mvelLangCls.getConstructor(MuleContext.class).newInstance(muleContext), muleContext);
            this.registerObject("_compatibilityPluginInstalled", true, muleContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void registerTransformerRegistry(MuleContext muleContext) throws RegistrationException {
        DefaultTransformersRegistry transformersRegistry = new DefaultTransformersRegistry();
        this.registerObject("_muleTransfromersRegistry", transformersRegistry, muleContext);
        this.registerObject("_converterResolver", new DynamicDataTypeConversionResolver(transformersRegistry), muleContext);
        this.registerObject("_muleTransformationService", new ExtendedTransformationService(muleContext), muleContext);
        this.registerObject("_muleTransfromerResolver", new TypeBasedTransformerResolver(), muleContext);
    }

    protected void registerLockFactory(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleLockProvider", new SingleServerLockProvider(), muleContext);
        this.registerObject("_muleLockFactory", new MuleLockFactory(), muleContext);
    }

    protected void registerSchedulerPoolsConfig(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleSchedulerPoolsConfig", SchedulerContainerPoolsConfig.getInstance(), muleContext);
        this.registerObject("_muleSchedulerBaseConfig", SchedulerConfig.config().withPrefix(muleContext.getConfiguration().getId()).withShutdownTimeout(() -> muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS), muleContext);
    }

    protected void registerCustomServices(MuleContext muleContext) {
        for (Map.Entry<String, CustomService> entry : ((InternalCustomizationService)muleContext.getCustomizationService()).getCustomServices().entrySet()) {
            entry.getValue().getServiceImpl().ifPresent(s -> {
                try {
                    this.registerObject((String)entry.getKey(), s, muleContext);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException(e);
                }
            });
        }
    }

    protected <T> void registerObject(String serviceId, T defaultServiceImpl, MuleContext muleContext) throws RegistrationException {
        this.registeredServices.add(serviceId);
        Optional<T> serviceImpl = ((InternalCustomizationService)muleContext.getCustomizationService()).getOverriddenService(serviceId).map(customService -> customService.getServiceImpl(defaultServiceImpl)).orElse(Optional.ofNullable(defaultServiceImpl));
        if (!serviceImpl.isPresent()) {
            return;
        }
        if (serviceImpl.get() instanceof MuleContextAware) {
            ((MuleContextAware)serviceImpl.get()).setMuleContext(muleContext);
        }
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject(serviceId, serviceImpl.get());
    }

    protected void registerObjectStoreManager(MuleContext muleContext) throws RegistrationException {
        this.registerObjectStorePartitions(muleContext);
        MuleObjectStoreManager osm = new MuleObjectStoreManager();
        osm.setBasePersistentStoreKey("_defaultPersistentObjectStore");
        osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
        osm.setMuleContext(muleContext);
        this.registerObject("_muleObjectStoreManager", osm, muleContext);
    }

    protected void registerObjectStorePartitions(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_defaultInMemoryObjectStore", this.getDefaultInMemoryObjectStore(), muleContext);
        this.registerObject("_defaultPersistentObjectStore", this.getDefaultPersistentObjectStore(), muleContext);
    }

    protected ObjectStore<Serializable> getDefaultPersistentObjectStore() {
        return DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore();
    }

    protected ObjectStore<Serializable> getDefaultInMemoryObjectStore() {
        return DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore();
    }

    protected void configureQueueManager(MuleContext muleContext) throws RegistrationException {
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        this.registerObject("_muleQueueManager", queueManager, muleContext);
        this.registerObject("_localQueueManager", queueManager, muleContext);
    }

    private void configureComponentTracerFactory(MuleContext muleContext) throws RegistrationException {
        DummyComponentTracerFactory componentTracerFactory = DummyComponentTracerFactory.getDummyComponentTracerFactory();
        this.registerObject("_muleCoreComponentTracerFactory", componentTracerFactory, muleContext);
    }

    protected void configureCoreTracer(MuleContext muleContext) throws RegistrationException {
        EventTracer<CoreEvent> tracer = NoopCoreEventTracer.getNoopCoreEventTracer();
        this.registerObject("_muleCoreEventTracer", tracer, muleContext);
    }

    protected void configureSpanExporterFactory(MuleContext muleContext) throws RegistrationException {
        NoopSpanExporterFactory spanExporterFactory = new NoopSpanExporterFactory();
        this.registerObject("_muleCoreExporterFactory", spanExporterFactory, muleContext);
    }

    protected void configureSpanExporterConfiguration(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleSpanExporterConfiguration", new EmptySpanExporterConfiguration(), muleContext);
    }
}

