/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.data.sample;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.data.sample.ComponentSampleDataProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.ExtensionResolvingContext;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataProviderMediator;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataException;

public class MuleSampleDataService
implements SampleDataService {
    private ConfigurationComponentLocator componentLocator;
    private ExtensionManager extensionManager;
    private MuleContext muleContext;
    private StreamingManager streamingManager;
    private ConnectionManager connectionManager;

    @Override
    public Message getSampleData(Location location) throws SampleDataException {
        Object component = this.findComponent(location);
        if (component instanceof ComponentSampleDataProvider) {
            Message message = ((ComponentSampleDataProvider)component).getSampleData();
            if (message == null) {
                throw new SampleDataException(String.format("No Sample Data available for Element at Location [%s]", location), "NO_DATA_AVAILABLE");
            }
            return message;
        }
        throw new SampleDataException(String.format("Element at Location [%s] is not capable of providing Sample Data", location), "NOT_SUPPORTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getSampleData(String extensionName, String componentName, Map<String, Object> parameters, Supplier<Optional<ConfigurationInstance>> configurationInstanceSupplier) throws SampleDataException {
        Preconditions.checkArgument(!StringUtils.isBlank(extensionName), "extensionName cannot be blank");
        Preconditions.checkArgument(!StringUtils.isBlank(componentName), "componentName cannot be blank");
        Preconditions.checkArgument(parameters != null, "parameters cannot be null");
        ExtensionModel extensionModel = this.extensionManager.getExtension(extensionName).orElse(null);
        if (extensionModel == null) {
            throw new SampleDataException(String.format("Extension '%s' was not found", extensionName), "INVALID_TARGET_EXTENSION");
        }
        ComponentModel componentModel = extensionModel.findComponentModel(componentName).orElse(null);
        if (componentModel == null) {
            throw new SampleDataException(String.format("Extension '%s' does not contain any component called '%s''", extensionName, componentName), "INVALID_TARGET_EXTENSION");
        }
        SampleDataProviderMediator mediator = new SampleDataProviderMediator(extensionModel, componentModel, new ResolvingComponent(extensionName, componentName), this.muleContext, new ReflectionCache(), this.streamingManager);
        ExtensionResolvingContext ctx = new ExtensionResolvingContext(configurationInstanceSupplier, this.connectionManager);
        try {
            Message message = mediator.getSampleData(StaticParameterValueResolver.from(this.replaceParameterAliases(parameters, componentModel)), () -> ctx.getConnection().orElse(null), () -> ctx.getConfig().orElse(null), () -> ctx.getConnectionProvider().orElse(null));
            return message;
        }
        finally {
            ctx.dispose();
        }
    }

    private Map<String, Object> replaceParameterAliases(Map<String, Object> parameters, ComponentModel model) {
        model.getAllParameterModels().forEach(param -> {
            String paramName = param.getName();
            if (parameters.containsKey(paramName)) {
                parameters.put(IntrospectionUtils.getImplementingName(param), parameters.remove(paramName));
            }
        });
        return parameters;
    }

    private Object findComponent(Location location) throws SampleDataException {
        return this.componentLocator.find(location).orElseThrow(() -> new SampleDataException(String.format("Invalid location [%s]. No element found at location.", location), "INVALID_LOCATION"));
    }

    @Inject
    public void setComponentLocator(ConfigurationComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    @Inject
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Inject
    public void setStreamingManager(StreamingManager streamingManager) {
        this.streamingManager = streamingManager;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private class ResolvingComponent
    extends AbstractComponent {
        private final ComponentLocation location;

        public ResolvingComponent(String extensionName, String componentName) {
            this.location = DefaultComponentLocation.from(extensionName + "/" + componentName);
        }

        @Override
        public ComponentLocation getLocation() {
            return this.location;
        }

        @Override
        public Location getRootContainerLocation() {
            return Location.builder().globalName(this.location.getLocation()).build();
        }
    }
}

