/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.NonBlockingCompletableMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class CompletableOperationExecutorFactory<T, M extends ComponentModel>
implements CompletableComponentExecutorFactory<M> {
    private final Class<T> implementationClass;
    private final Method operationMethod;

    public CompletableOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        Preconditions.checkArgument(implementationClass != null, "implementationClass cannot be null");
        Preconditions.checkArgument(operationMethod != null, "operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
    }

    @Override
    public CompletableComponentExecutor<M> createExecutor(M operationModel, Map<String, Object> parameters) {
        DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder(this.implementationClass, new ReflectionCache());
        parameters.forEach((k, v) -> objectBuilder.addPropertyResolver((String)k, (ValueResolver<Object>)new StaticValueResolver<Object>(v)));
        Object delegate = FunctionalUtils.withNullEvent(event -> {
            try {
                return objectBuilder.build(ValueResolvingContext.builder(event).build());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of operation class " + this.implementationClass.getName()), (Throwable)e);
            }
        });
        if (MuleExtensionUtils.isNonBlocking(operationModel)) {
            return new NonBlockingCompletableMethodOperationExecutor<M>(operationModel, this.operationMethod, delegate);
        }
        return new CompletableMethodOperationExecutor<M>(operationModel, this.operationMethod, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C extends Component & Initialisable> Map<String, Object> extractExecutorInitialisationParams(ExtensionModel extensionModel, ComponentModel componentModel, Map<String, ? extends Object> operationParameters, C actingComponent, Optional<ConfigurationInstance> staticConfig, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache) throws InitialisationException {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        LazyValue<Supplier<ValueResolvingContext>> resolvingContext = new LazyValue<Supplier<ValueResolvingContext>>(() -> FunctionalUtils.withNullEvent(event -> ValueResolvingContext.builder(event, expressionManager).withConfig(staticConfig).build()));
        LazyValue<Supplier<Boolean>> dynamicConfig = new LazyValue<Supplier<Boolean>>(() -> extensionManager.getConfigurationProvider(extensionModel, componentModel, ((ValueResolvingContext)resolvingContext.get()).getEvent()).map(ConfigurationProvider::isDynamic).orElse(false));
        try {
            for (ParameterGroupModel group : componentModel.getParameterGroupModels()) {
                List<ParameterModel> fieldParameters;
                if (group.getName().equals("General")) {
                    for (ParameterModel p : group.getParameterModels()) {
                        Object value;
                        if (!p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent() || (value = operationParameters.get(p.getName())) == null) continue;
                        initParams.put(IntrospectionUtils.getMemberName(p), CompletableOperationExecutorFactory.resolveComponentExecutorParam(resolvingContext, dynamicConfig, p, actingComponent, value));
                    }
                    continue;
                }
                ParameterGroupDescriptor groupDescriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(g -> g.getDescriptor()).orElse(null);
                if (groupDescriptor == null || (fieldParameters = CompletableOperationExecutorFactory.getGroupsOfFieldParameters(group)).isEmpty()) continue;
                ObjectBuilder groupBuilder = CompletableOperationExecutorFactory.createFieldParameterGroupBuilder(groupDescriptor, operationParameters, fieldParameters, reflectionCache);
                try {
                    initParams.put(((Field)groupDescriptor.getContainer()).getName(), groupBuilder.build((ValueResolvingContext)((Object)resolvingContext.get())));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(e);
                }
            }
            HashMap<String, Object> hashMap = initParams;
            return hashMap;
        }
        finally {
            resolvingContext.ifComputed(ValueResolvingContext::close);
        }
    }

    private static <C extends Component & Initialisable> Object resolveComponentExecutorParam(LazyValue<ValueResolvingContext> resolvingContext, Supplier<Boolean> dynamicConfig, ParameterModel p, C actingComponent, Object value) throws InitialisationException {
        Object resolvedValue = null;
        try {
            if (value instanceof ConfigOverrideValueResolverWrapper && (resolvedValue = (Object)((ConfigOverrideValueResolverWrapper)value).resolveWithoutConfig(resolvingContext.get())) == null && dynamicConfig.get().booleanValue()) {
                ComponentLocation location = actingComponent.getLocation();
                String message = String.format("Component '%s' at %s uses a dynamic configuration and defines configuration override parameter '%s' which is assigned on initialization. That combination is not supported. Please use a non dynamic configuration or don't set the parameter.", location != null ? location.getComponentIdentifier().getIdentifier().toString() : actingComponent, actingComponent, p.getName());
                throw new InitialisationException(I18nMessageFactory.createStaticMessage(message), (Initialisable)actingComponent);
            }
            if (resolvedValue == null) {
                resolvedValue = value instanceof ValueResolver ? ResolverUtils.resolveValue((ValueResolver)value, resolvingContext.get()) : value;
            }
            return resolvedValue;
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private static List<ParameterModel> getGroupsOfFieldParameters(ParameterGroupModel group) {
        return group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private static ObjectBuilder createFieldParameterGroupBuilder(ParameterGroupDescriptor groupDescriptor, Map<String, ? extends Object> parameters, List<ParameterModel> fieldParameters, ReflectionCache reflectionCache) {
        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(groupDescriptor.getType().getDeclaringClass().get(), reflectionCache);
        fieldParameters.forEach(p -> {
            if (parameters.containsKey(p.getName())) {
                ValueResolver resolver = CompletableOperationExecutorFactory.asValueResolver(parameters.get(p.getName()));
                Optional<Field> memberField = IntrospectionUtils.getMemberField(p);
                if (memberField.isPresent()) {
                    groupBuilder.addPropertyResolver(IntrospectionUtils.getMemberField(p).get(), (ValueResolver<Object>)resolver);
                } else {
                    groupBuilder.addPropertyResolver(p.getName(), (ValueResolver<Object>)resolver);
                }
            }
        });
        return groupBuilder;
    }

    private static ValueResolver asValueResolver(Object value) {
        return value instanceof ValueResolver ? (ValueResolver<Object>)value : new StaticValueResolver<Object>(value);
    }
}

