/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.util.ExtensionConnectivityUtils;

public class ConnectionProviderDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        if (ExtensionConnectivityUtils.isReconnectionStrategySupported(declaration)) {
            return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

                @Override
                protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                    InfrastructureParameterBuilder.addReconnectionConfigParameter(declaration);
                    ConnectionManagementType managementType = declaration.getConnectionManagementType();
                    if (managementType == ConnectionManagementType.POOLING) {
                        InfrastructureParameterBuilder.addPoolingProfileParameter(declaration);
                    }
                }
            });
        }
        return Optional.empty();
    }
}

