/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.util.message.stream.UnclosableCursorStream;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.MethodArgumentResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationTransactionalActionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkOperationTransactionalActionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.BackPressureContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentLocationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CorrelationInfoArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.DefaultEncodingArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.DistributedTraceContextManagerResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ErrorArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExtensionsClientArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.FlowListenerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.LegacySourceCallbackContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.LiteralArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MediaTypeArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NotificationHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.RetryPolicyTemplateArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.RouterCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkBackPressureContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkCompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkExtensionsClientArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkFlowListenerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkNotificationHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkRouterCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkSecurityContextHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkSourceResultArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SdkVoidCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SecurityContextHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCallbackContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceResultArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StreamingHelperArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.VoidCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ParameterGroupUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.runtime.process.RouterCompletionCallback;
import org.mule.sdk.api.runtime.process.VoidCompletionCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.security.AuthenticationHandler;

public final class MethodArgumentResolverDelegate
implements ArgumentResolverDelegate,
Initialisable {
    private static final ArgumentResolver<Object> CONFIGURATION_ARGUMENT_RESOLVER = new ConfigurationArgumentResolver();
    private static final ArgumentResolver<Object> CONNECTOR_ARGUMENT_RESOLVER = new ConnectionArgumentResolver();
    private static final ArgumentResolver<MediaType> MEDIA_TYPE_ARGUMENT_RESOLVER = new MediaTypeArgumentResolver();
    private static final ArgumentResolver<String> DEFAULT_ENCODING_ARGUMENT_RESOLVER = new DefaultEncodingArgumentResolver();
    private static final ArgumentResolver<org.mule.runtime.extension.api.runtime.source.SourceCallbackContext> LEGACY_SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER = new LegacySourceCallbackContextArgumentResolver();
    private static final ArgumentResolver<SourceCallbackContext> SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER = new SourceCallbackContextArgumentResolver();
    private static final ArgumentResolver<Error> ERROR_ARGUMENT_RESOLVER = new ErrorArgumentResolver();
    private static final ArgumentResolver<org.mule.sdk.api.runtime.process.CompletionCallback> NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER = new SdkCompletionCallbackArgumentResolver();
    private static final ArgumentResolver<CompletionCallback> LEGACY_NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER = new CompletionCallbackArgumentResolver();
    private static final ArgumentResolver<org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback> LEGACY_ROUTER_CALLBACK_ARGUMENT_RESOLVER = new RouterCallbackArgumentResolver();
    private static final ArgumentResolver<RouterCompletionCallback> ROUTER_CALLBACK_ARGUMENT_RESOLVER = new SdkRouterCallbackArgumentResolver();
    private static final ArgumentResolver<org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback> LEGACY_VOID_CALLBACK_ARGUMENT_RESOLVER = new VoidCallbackArgumentResolver();
    private static final ArgumentResolver<VoidCompletionCallback> VOID_CALLBACK_ARGUMENT_RESOLVER = new SdkVoidCallbackArgumentResolver();
    private static final ArgumentResolver<SourceCompletionCallback> ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER = new SourceCompletionCallbackArgumentResolver();
    private static final ArgumentResolver<org.mule.runtime.extension.api.security.AuthenticationHandler> LEGACY_SECURITY_CONTEXT_HANDLER = new SecurityContextHandlerArgumentResolver();
    private static final ArgumentResolver<AuthenticationHandler> SECURITY_CONTEXT_HANDLER = new SdkSecurityContextHandlerArgumentResolver();
    private static final ArgumentResolver<FlowListener> LEGACY_FLOW_LISTENER_ARGUMENT_RESOLVER = new FlowListenerArgumentResolver();
    private static final ArgumentResolver<org.mule.sdk.api.runtime.operation.FlowListener> FLOW_LISTENER_ARGUMENT_RESOLVER = new SdkFlowListenerArgumentResolver();
    private static final ArgumentResolver<SourceResult> LEGACY_SOURCE_RESULT_ARGUMENT_RESOLVER = new SourceResultArgumentResolver(ERROR_ARGUMENT_RESOLVER, LEGACY_SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER);
    private static final ArgumentResolver<org.mule.sdk.api.runtime.source.SourceResult> SOURCE_RESULT_ARGUMENT_RESOLVER = new SdkSourceResultArgumentResolver(ERROR_ARGUMENT_RESOLVER, SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER);
    private static final ArgumentResolver<BackPressureContext> LEGACY_BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER = new BackPressureContextArgumentResolver();
    private static final ArgumentResolver<org.mule.sdk.api.runtime.source.BackPressureContext> BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER = new SdkBackPressureContextArgumentResolver();
    private static final ArgumentResolver<ComponentLocation> COMPONENT_LOCATION_ARGUMENT_RESOLVER = new ComponentLocationArgumentResolver();
    private static final ArgumentResolver<OperationTransactionalAction> LEGACY_OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER = new OperationTransactionalActionArgumentResolver();
    private static final ArgumentResolver<org.mule.sdk.api.tx.OperationTransactionalAction> OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER = new SdkOperationTransactionalActionArgumentResolver();
    private static final ArgumentResolver<CorrelationInfo> CORRELATION_INFO_ARGUMENT_RESOLVER = new CorrelationInfoArgumentResolver();
    private static final ArgumentResolver<NotificationEmitter> LEGACY_NOTIFICATION_HANDLER_ARGUMENT_RESOLVER = new NotificationHandlerArgumentResolver();
    private static final ArgumentResolver<org.mule.sdk.api.notification.NotificationEmitter> NOTIFICATION_HANDLER_ARGUMENT_RESOLVER = new SdkNotificationHandlerArgumentResolver();
    private static final ArgumentResolver<RetryPolicyTemplate> RETRY_POLICY_TEMPLATE_ARGUMENT_RESOLVER = new RetryPolicyTemplateArgumentResolver();
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private InternalProfilingService profilingService;
    @Inject
    private ExtensionsClient extensionsClient;
    private final List<ParameterGroupModel> parameterGroupModels;
    private final Method method;
    private final JavaTypeLoader typeLoader = new JavaTypeLoader(this.getClass().getClassLoader());
    private ArgumentResolver<Object>[] argumentResolvers;
    private Map<Parameter, ParameterGroupArgumentResolver<?>> parameterGroupResolvers;

    public MethodArgumentResolverDelegate(List<ParameterGroupModel> parameterGroupModels, Method method) {
        this.parameterGroupModels = parameterGroupModels;
        this.method = method;
    }

    private void initArgumentResolvers() {
        Object[] parameterTypes = this.method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            this.argumentResolvers = new ArgumentResolver[0];
            return;
        }
        this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        Parameter[] parameters = this.method.getParameters();
        this.parameterGroupResolvers = this.getParameterGroupResolvers(this.parameterGroupModels);
        List<String> paramNames = MuleExtensionAnnotationParser.getParamNames(this.method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            Parameter parameter = parameters[i];
            Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
            ArgumentResolver<ExtensionsClient> argumentResolver = MethodArgumentResolverUtils.isConfigParameter(annotations) ? CONFIGURATION_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isConnectionParameter(annotations) ? CONNECTOR_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isDefaultEncoding(annotations) ? DEFAULT_ENCODING_ARGUMENT_RESOLVER : (Error.class.isAssignableFrom((Class<?>)parameterType) ? ERROR_ARGUMENT_RESOLVER : (org.mule.runtime.extension.api.runtime.source.SourceCallbackContext.class.equals(parameterType) ? LEGACY_SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER : (SourceCallbackContext.class.equals(parameterType) ? SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER : (ParameterGroupUtils.hasParameterGroupAnnotation(annotations.keySet()) && ParameterGroupUtils.isParameterGroupShowInDsl(annotations).get() == false && IntrospectionUtils.isParameterContainer(annotations.keySet(), this.typeLoader.load((Type)parameterType)) ? (ExtensionsClientArgumentResolver)((Object)this.parameterGroupResolvers.get(parameter)) : (MethodArgumentResolverUtils.isParameterResolverType(parameterType) ? new ParameterResolverArgumentResolver(paramNames.get(i)) : (TypedValue.class.equals(parameterType) ? new TypedValueArgumentResolver(paramNames.get(i)) : (MethodArgumentResolverUtils.isLiteralType(parameterType) ? new LiteralArgumentResolver(paramNames.get(i), parameterType) : (CompletionCallback.class.equals(parameterType) ? LEGACY_NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER : (org.mule.sdk.api.runtime.process.CompletionCallback.class.equals(parameterType) ? NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER : (ExtensionsClient.class.equals(parameterType) ? new ExtensionsClientArgumentResolver(this.extensionsClient) : (org.mule.sdk.api.client.ExtensionsClient.class.equals(parameterType) ? new SdkExtensionsClientArgumentResolver(this.extensionsClient) : (org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback.class.equals(parameterType) ? LEGACY_ROUTER_CALLBACK_ARGUMENT_RESOLVER : (RouterCompletionCallback.class.equals(parameterType) ? ROUTER_CALLBACK_ARGUMENT_RESOLVER : (org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback.class.equals(parameterType) ? LEGACY_VOID_CALLBACK_ARGUMENT_RESOLVER : (VoidCompletionCallback.class.equals(parameterType) ? VOID_CALLBACK_ARGUMENT_RESOLVER : (MediaType.class.equals(parameterType) ? MEDIA_TYPE_ARGUMENT_RESOLVER : (org.mule.runtime.extension.api.security.AuthenticationHandler.class.equals(parameterType) ? LEGACY_SECURITY_CONTEXT_HANDLER : (AuthenticationHandler.class.equals(parameterType) ? SECURITY_CONTEXT_HANDLER : (FlowListener.class.equals(parameterType) ? LEGACY_FLOW_LISTENER_ARGUMENT_RESOLVER : (org.mule.sdk.api.runtime.operation.FlowListener.class.equals(parameterType) ? FLOW_LISTENER_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isStreamingHelperType(parameterType) ? new StreamingHelperArgumentResolver() : (SourceResult.class.equals(parameterType) ? LEGACY_SOURCE_RESULT_ARGUMENT_RESOLVER : (org.mule.sdk.api.runtime.source.SourceResult.class.equals(parameterType) ? SOURCE_RESULT_ARGUMENT_RESOLVER : (BackPressureContext.class.equals(parameterType) ? LEGACY_BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER : (org.mule.sdk.api.runtime.source.BackPressureContext.class.equals(parameterType) ? BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isSourceCompletionCallbackType(parameterType) ? ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER : (ComponentLocation.class.equals(parameterType) ? COMPONENT_LOCATION_ARGUMENT_RESOLVER : (OperationTransactionalAction.class.equals(parameterType) ? LEGACY_OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER : (org.mule.sdk.api.tx.OperationTransactionalAction.class.equals(parameterType) ? OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isCorrelationInfoType(parameterType) ? CORRELATION_INFO_ARGUMENT_RESOLVER : (MethodArgumentResolverUtils.isDistributedTraceContextManagerType(parameterType) ? new DistributedTraceContextManagerResolver(this.profilingService.getCoreEventTracer()) : (NotificationEmitter.class.equals(parameterType) ? LEGACY_NOTIFICATION_HANDLER_ARGUMENT_RESOLVER : (org.mule.sdk.api.notification.NotificationEmitter.class.equals(parameterType) ? NOTIFICATION_HANDLER_ARGUMENT_RESOLVER : (RetryPolicyTemplate.class.equals(parameterType) ? RETRY_POLICY_TEMPLATE_ARGUMENT_RESOLVER : new ByParameterNameArgumentResolver(paramNames.get(i))))))))))))))))))))))))))))))))))))));
            this.argumentResolvers[i] = this.addResolverDecorators(argumentResolver, parameter);
        }
    }

    @Override
    public ArgumentResolver<?>[] getArgumentResolvers() {
        ArgumentResolver[] copy = new ArgumentResolver[this.argumentResolvers.length];
        System.arraycopy(this.argumentResolvers, 0, copy, 0, this.argumentResolvers.length);
        return copy;
    }

    @Override
    public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
        Object[] parameterValues = new Object[this.argumentResolvers.length];
        for (int i = 0; i < this.argumentResolvers.length; ++i) {
            parameterValues[i] = this.argumentResolvers[i].resolve(executionContext);
        }
        return parameterValues;
    }

    @Override
    public Supplier<Object>[] resolveDeferred(ExecutionContext executionContext, Class<?>[] parameterTypes) {
        Supplier[] parameterValues = new Supplier[this.argumentResolvers.length];
        for (int i = 0; i < this.argumentResolvers.length; ++i) {
            int itemIndex = i;
            parameterValues[i] = new LazyValue<Supplier<Object>>(() -> this.argumentResolvers[itemIndex].resolve(executionContext));
        }
        return parameterValues;
    }

    private ArgumentResolver<Object> addResolverDecorators(ArgumentResolver<Object> resolver, Parameter parameter) {
        Class<?> argumentType = parameter.getType();
        if (argumentType.isPrimitive()) {
            resolver = this.addPrimitiveTypeDefaultValueDecorator(resolver, argumentType);
        } else if (InputStream.class.equals(argumentType)) {
            resolver = new InputStreamArgumentResolverDecorator(resolver);
        } else if (TypedValue.class.equals(argumentType)) {
            Class genericClass;
            Type generic;
            if (parameter.getParameterizedType() instanceof ParameterizedType && (generic = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0]) instanceof Class && (CursorProvider.class.isAssignableFrom(genericClass = (Class)generic) || InputStream.class.isAssignableFrom(genericClass) || Object.class.equals((Object)genericClass))) {
                resolver = new TypedValueCursorArgumentResolverDecorator(resolver);
            }
        } else if (Object.class.equals(argumentType)) {
            resolver = new ObjectArgumentResolverDecorator(resolver);
        }
        return resolver;
    }

    private ArgumentResolver<Object> addPrimitiveTypeDefaultValueDecorator(ArgumentResolver<Object> resolver, Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, 0);
        }
        if (type.equals(Boolean.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, false);
        }
        if (type.equals(Float.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, Float.valueOf(0.0f));
        }
        if (type.equals(Long.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, 0L);
        }
        if (type.equals(Byte.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, (byte)0);
        }
        if (type.equals(Short.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, (short)0);
        }
        if (type.equals(Double.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, 0.0);
        }
        if (type.equals(Character.TYPE)) {
            return new DefaultValueArgumentResolverDecorator(resolver, Character.valueOf('\u0000'));
        }
        return resolver;
    }

    private Map<Parameter, ParameterGroupArgumentResolver<? extends Object>> getParameterGroupResolvers(List<ParameterGroupModel> parameterGroupModels) {
        return parameterGroupModels.stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null)).filter(group -> group != null && group.getContainer() instanceof Parameter).collect(Collectors.toImmutableMap(group -> (Parameter)group.getContainer(), group -> new ParameterGroupArgumentResolver((ParameterGroupDescriptor)group, this.reflectionCache, this.expressionManager)));
    }

    @Override
    public void initialise() throws InitialisationException {
        this.initArgumentResolvers();
    }

    private static abstract class ArgumentResolverDecorator<T>
    implements ArgumentResolver<Object> {
        private final ArgumentResolver<Object> decoratee;

        public ArgumentResolverDecorator(ArgumentResolver<Object> decoratee) {
            this.decoratee = decoratee;
        }

        @Override
        public Object resolve(ExecutionContext executionContext) {
            return this.decorate(this.decoratee.resolve(executionContext));
        }

        protected abstract T decorate(T var1);

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.decoratee.toString() + ")";
        }
    }

    private static class ObjectArgumentResolverDecorator
    extends ArgumentResolverDecorator<Object> {
        public ObjectArgumentResolverDecorator(ArgumentResolver<Object> decoratee) {
            super(decoratee);
        }

        @Override
        protected Object decorate(Object value) {
            return ResolverUtils.resolveCursorAsUnclosable(value);
        }
    }

    private static class TypedValueCursorArgumentResolverDecorator
    extends ArgumentResolverDecorator<TypedValue<?>> {
        public TypedValueCursorArgumentResolverDecorator(ArgumentResolver<Object> decoratee) {
            super(decoratee);
        }

        @Override
        protected TypedValue<?> decorate(TypedValue<?> value) {
            return ResolverUtils.resolveCursorAsUnclosable(value);
        }
    }

    private static class DefaultValueArgumentResolverDecorator
    extends ArgumentResolverDecorator<Object> {
        private final Object defaultValue;

        public DefaultValueArgumentResolverDecorator(ArgumentResolver<Object> decoratee, Object defaultValue) {
            super(decoratee);
            this.defaultValue = defaultValue;
        }

        @Override
        protected Object decorate(Object value) {
            return value != null ? value : this.defaultValue;
        }

        @Override
        public String toString() {
            return super.toString() + "; defaultValue: " + this.defaultValue + " (" + this.defaultValue.getClass().getName() + ")";
        }
    }

    private static class InputStreamArgumentResolverDecorator
    extends ArgumentResolverDecorator<InputStream> {
        public InputStreamArgumentResolverDecorator(ArgumentResolver<Object> decoratee) {
            super(decoratee);
        }

        @Override
        protected InputStream decorate(InputStream value) {
            return value instanceof CursorStream ? new UnclosableCursorStream((CursorStream)value) : value;
        }
    }
}

