/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;

public class FileConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider {
    private static final String FILE_PREFIX = "file::";
    private final ResourceProvider resourceProvider;
    private final String description;

    public FileConfigurationPropertiesProvider(ResourceProvider resourceProvider, String description) {
        this.resourceProvider = resourceProvider;
        this.description = description;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        if (!configurationAttributeKey.startsWith(FILE_PREFIX)) return Optional.empty();
        String path = configurationAttributeKey.substring(FILE_PREFIX.length());
        try (InputStream is = this.resourceProvider.getResourceAsStream(path);){
            if (is == null) return Optional.empty();
            String value = IOUtils.toString(is);
            Optional<ConfigurationProperty> optional = Optional.of(new DefaultConfigurationProperty(this, configurationAttributeKey, value));
            return optional;
        }
        catch (IOException | ResourceNotFoundException exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }
}

