/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.pom.parser.api.model.ArtifactCoordinates;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderConfigurationLoader;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;
import org.mule.runtime.module.tooling.internal.ApplicationSupplier;

public abstract class AbstractArtifactAgnosticServiceBuilder<T extends ArtifactAgnosticServiceBuilder, S>
implements ArtifactAgnosticServiceBuilder<T, S> {
    private static final String TMP_APP_ARTIFACT_ID = "temp-artifact-id";
    private static final String TMP_APP_GROUP_ID = "temp-group-id";
    private static final String TMP_APP_VERSION = "temp-version";
    private static final String TMP_APP_MODEL_VERSION = "4.0.0";
    private final DefaultApplicationFactory defaultApplicationFactory;
    private ArtifactDeclaration artifactDeclaration;
    private MavenModelBuilder model;
    private Map<String, String> artifactProperties = Collections.emptyMap();

    protected AbstractArtifactAgnosticServiceBuilder(DefaultApplicationFactory defaultApplicationFactory) {
        this.defaultApplicationFactory = defaultApplicationFactory;
        this.createTempMavenModel();
    }

    @Override
    public T setArtifactProperties(Map<String, String> artifactProperties) {
        Preconditions.checkState(artifactProperties != null, "artifactProperties cannot be null");
        this.artifactProperties = artifactProperties;
        return this.getThis();
    }

    @Override
    public T setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        Preconditions.checkState(artifactDeclaration != null, "artifactDeclaration cannot be null");
        this.artifactDeclaration = artifactDeclaration;
        return this.getThis();
    }

    @Override
    public T addDependency(String groupId, String artifactId, String artifactVersion, String classifier, String type) {
        BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(artifactVersion).setType(type).setClassifier(classifier).build();
        BundleDependency bundleDependency = new BundleDependency.Builder().setBundleDescriptor(bundleDescriptor).build();
        this.addMavenModelDependency(bundleDependency);
        return this.getThis();
    }

    @Override
    public T addDependency(ArtifactAgnosticServiceBuilder.Dependency dependency) {
        BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setType(dependency.getType()).setClassifier(dependency.getClassifier()).setOptional(dependency.getOptional()).setSystemPath(dependency.getSystemPath()).setExclusions(dependency.getExclusions().stream().map(exclusion -> new ArtifactCoordinates(exclusion.getGroupId(), exclusion.getArtifactId())).collect(Collectors.toList())).build();
        BundleDependency.Builder bundleDependencyBuilder = new BundleDependency.Builder().setBundleDescriptor(bundleDescriptor);
        if (dependency.getScope() != null) {
            bundleDependencyBuilder.setScope(BundleScope.valueOf(dependency.getScope().toUpperCase())).build();
        }
        this.addMavenModelDependency(bundleDependencyBuilder.build());
        return this.getThis();
    }

    private void addMavenModelDependency(BundleDependency bundleDependency) {
        BundleDescriptor descriptor = bundleDependency.getDescriptor();
        if (!"mule-plugin".equals(descriptor.getClassifier().orElse(null))) {
            this.model.addSharedLibraryDependency(descriptor.getGroupId(), descriptor.getArtifactId());
        }
        this.model.addDependency(bundleDependency);
    }

    @Override
    public S build() {
        Preconditions.checkState(this.artifactDeclaration != null, "artifact configuration cannot be null");
        return this.createService(() -> {
            Object classLoaderConfiguration;
            String applicationName = UUID.getUUID() + "-artifact-temp-app";
            File applicationFolder = new File(MuleFoldersUtil.getExecutionFolder(), applicationName);
            Properties deploymentProperties = new Properties();
            deploymentProperties.putAll(this.forcedDeploymentProperties());
            Set<String> configs = Collections.singleton("empty-app.xml");
            this.model.createDeployablePomFile(applicationFolder.toPath());
            this.model.updateArtifactPom(applicationFolder.toPath());
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider(AbstractArtifactAgnosticServiceBuilder.class.getClassLoader());
            try (MavenClient mavenClient = mavenClientProvider.createMavenClient(GlobalConfigLoader.getMavenConfig());){
                classLoaderConfiguration = new DeployableMavenClassLoaderConfigurationLoader(Optional.of(mavenClient)).load(applicationFolder, Collections.singletonMap(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor.class.getName(), this.createTempBundleDescriptor()), ArtifactType.APP);
            }
            for (String config : configs) {
                IOUtils.copy((URL)this.getClass().getClassLoader().getResource(config), (File)new File(applicationFolder, config));
            }
            File destinationFolder = applicationFolder.toPath().resolve("META-INF").resolve("mule-artifact").toFile();
            Files.createDirectories(destinationFolder.toPath(), new FileAttribute[0]);
            MuleVersion muleVersion = new MuleVersion("4.4.0");
            String artifactJson = new MuleApplicationModelJsonSerializer().serialize(this.serializeModel(applicationName, (ClassLoaderConfiguration)classLoaderConfiguration, configs, muleVersion.toCompleteNumericVersion()));
            try (FileWriter fileWriter = new FileWriter(new File(destinationFolder, "mule-artifact.json"));){
                fileWriter.write(artifactJson);
            }
            DeployableArtifactDescriptor artifactDescriptor = this.defaultApplicationFactory.createArtifactDescriptor(applicationFolder, (Optional)Optional.of(deploymentProperties));
            artifactDescriptor.setMinMuleVersion(muleVersion);
            ((ApplicationDescriptor)artifactDescriptor).setArtifactDeclaration(this.artifactDeclaration);
            ((ApplicationDescriptor)artifactDescriptor).setAppProperties(this.artifactProperties);
            return this.defaultApplicationFactory.createArtifact((ApplicationDescriptor)artifactDescriptor);
        });
    }

    private MuleApplicationModel serializeModel(String appName, ClassLoaderConfiguration classLoaderConfiguration, Set<String> configs, String muleVersion) {
        ImmutableMap attributes = ImmutableMap.of((Object)"exportedResources", (Object)Lists.newArrayList(classLoaderConfiguration.getExportedResources()), (Object)"exportedPackages", (Object)Lists.newArrayList(classLoaderConfiguration.getExportedPackages()));
        MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor = new MuleArtifactLoaderDescriptor("mule", (Map<String, Object>)attributes);
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)builder.setName(appName)).setMinMuleVersion(muleVersion)).setRequiredProduct(Product.MULE)).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withClassLoaderModelDescriptorLoader(muleArtifactLoaderDescriptor)).setConfigs((Set)configs);
        return (MuleApplicationModel)builder.build();
    }

    protected Map<String, String> forcedDeploymentProperties() {
        return Collections.emptyMap();
    }

    protected abstract S createService(ApplicationSupplier var1);

    private void createTempMavenModel() {
        MavenModelBuilderProvider mavenModelBuilderProvider = MavenModelBuilderProvider.discoverProvider();
        this.model = mavenModelBuilderProvider.createMavenModelBuilder(TMP_APP_GROUP_ID, TMP_APP_ARTIFACT_ID, "4.4.0", Optional.of(TMP_APP_MODEL_VERSION), Optional.empty());
    }

    private org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor createTempBundleDescriptor() {
        return new BundleDescriptor.Builder().setArtifactId(TMP_APP_ARTIFACT_ID).setGroupId(TMP_APP_GROUP_ID).setVersion(TMP_APP_VERSION).setClassifier("mule-application").build();
    }

    private T getThis() {
        return (T)this;
    }

    MavenModelBuilder getModel() {
        return this.model;
    }

    void setModel(MavenModelBuilder model) {
        this.model = model;
    }
}

