/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.observability.FileConfiguration;
import org.mule.runtime.tracer.common.watcher.TracingConfigurationFileWatcher;
import org.mule.runtime.tracer.exporter.config.api.SpanExporterConfiguration;

public class FileSpanExporterConfiguration
extends FileConfiguration
implements SpanExporterConfiguration,
Disposable {
    private final MuleContext muleContext;
    public static final String MULE_TRACING_CONFIGURATION_PATH = "mule.tracer.config.path";
    private final String PROPERTIES_FILE_NAME = System.getProperty("mule.tracer.config.path", "tracer-exporter.conf");
    private ConfigurationPropertiesResolver propertyResolver;
    private JsonNode configuration;
    private ClassLoaderResourceProvider resourceProvider;
    private boolean propertiesInitialised;
    private URL configurationUrl;
    private final CompositeRunnable doOnConfigurationChanged = new CompositeRunnable();
    private TracingConfigurationFileWatcher tracingConfigurationFileWatcher;
    private String resolvedConfigurationFilePath;
    private boolean tracingConfigurationFileWatcherInitialised;

    public FileSpanExporterConfiguration(MuleContext muleContext) {
        super(muleContext);
        this.muleContext = muleContext;
    }

    @Override
    public String getStringValue(String key) {
        if (!this.propertiesInitialised) {
            this.initialiseProperties();
            this.propertiesInitialised = true;
        }
        return super.getStringValue(key);
    }

    @Override
    protected boolean isAValueCorrespondingToAPath(String key) {
        return key.equals("mule.openTelemetry.tracer.exporter.tls.caFileLocation") || key.equals("mule.openTelemetry.tracer.exporter.tls.keyFileLocation");
    }

    private void getSpanExporterConfigurationProperties() {
        if (Boolean.getBoolean("mule.tracing.configuration.enableTracerConfigurationAtApplicationLevel")) {
            try {
                InputStream is = this.resourceProvider.getResourceAsStream(this.getPropertiesFileName());
                this.configuration = FileSpanExporterConfiguration.loadConfiguration(is);
                this.configurationUrl = ClassUtils.getResourceOrFail(this.getPropertiesFileName(), this.getExecutionClassLoader(this.muleContext), true);
            }
            catch (IOException | MuleRuntimeException is) {}
        } else {
            try {
                String resourcePath = this.resolveConfigurationFilePath();
                InputStream is = IOUtils.getResourceAsStream(resourcePath, FileSpanExporterConfiguration.class);
                this.configuration = FileSpanExporterConfiguration.loadConfiguration(is);
                this.configurationUrl = IOUtils.getResourceAsUrl(resourcePath, FileSpanExporterConfiguration.class, true, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String resolveConfigurationFilePath() {
        if (this.resolvedConfigurationFilePath != null) {
            return this.resolvedConfigurationFilePath;
        }
        this.resolvedConfigurationFilePath = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName());
        return this.resolvedConfigurationFilePath;
    }

    protected String getPropertiesFileName() {
        return this.PROPERTIES_FILE_NAME;
    }

    protected void initialiseProperties() {
        this.resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        this.getSpanExporterConfigurationProperties();
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());
        if (this.configurationUrl != null && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new TracingConfigurationFileWatcher(this.configurationUrl.getFile(), (Runnable)this.doOnConfigurationChanged);
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    @Override
    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
        this.doOnConfigurationChanged.addRunnable(doOnConfigurationChanged);
    }

    @Override
    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    @Override
    protected JsonNode getConfiguration() {
        return this.configuration;
    }

    @Override
    protected ConfigurationPropertiesResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    private class CompositeRunnable
    implements Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        CompositeRunnable() {
            this.runnables.add(FileSpanExporterConfiguration.this::initialiseProperties);
        }

        @Override
        public void run() {
            this.runnables.forEach(Runnable::run);
        }

        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }
}

