/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.privileged.transformer.TransformersRegistry;

@NoExtend
public class DefaultTransformationService
implements TransformationService {
    protected MuleContext muleContext;
    @Inject
    private TransformersRegistry transformersRegistry;

    @Inject
    public DefaultTransformationService(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private Message internalTransform(Message message, DataType outputDataType) throws MessageTransformerException {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkNotNull((Object)outputDataType, (Object)"DataType cannot be null");
        return Message.builder(message).value(this.getPayload(message, outputDataType, this.resolveEncoding(message))).build();
    }

    private Object internalTransform(Object value, DataType valueDataType, DataType expectedDataType) throws MessageTransformerException, TransformerException {
        if (value != null) {
            Transformer transformer;
            try {
                transformer = this.transformersRegistry.lookupTransformer(valueDataType, expectedDataType);
            }
            catch (TransformerException e) {
                throw new TransformerException(I18nMessageFactory.createStaticMessage("The value '%s' of type %s could not be transformed to the desired type %s", value.toString().trim(), value.getClass().getName(), expectedDataType.getType().getName()), (Throwable)e);
            }
            return transformer.transform(value);
        }
        return null;
    }

    protected <T> T getPayload(Message message, DataType resultType, Charset encoding) throws MessageTransformerException {
        if (resultType == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("resultType").getMessage());
        }
        DataType dataType = DataType.builder(resultType).type(message.getPayload().getDataType().getType()).build();
        if (resultType.isCompatibleWith(dataType)) {
            return message.getPayload().getValue();
        }
        Transformer transformer = null;
        try {
            transformer = this.transformersRegistry.lookupTransformer(dataType, resultType);
            if (transformer == null) {
                throw new MessageTransformerException(CoreMessages.noTransformerFoundForMessage(dataType, resultType), null, message);
            }
            Object result = transformer.transform(message, encoding);
            this.checkResultDataType(message, resultType, result);
            return (T)result;
        }
        catch (MessageTransformerException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw new MessageTransformerException(transformer, e, message);
        }
    }

    protected void checkResultDataType(Message message, DataType resultType, Object value) throws MessageTransformerException {
        if (value != null && !resultType.getType().isAssignableFrom(value.getClass())) {
            TypedValue<Object> actualType = TypedValue.of(value);
            Message transformedMessage = Message.builder(message).payload(actualType).build();
            throw new MessageTransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(resultType, actualType), null, transformedMessage);
        }
    }

    protected Charset resolveEncoding(Message message) {
        return message.getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(this.muleContext));
    }

    @Override
    public Object transform(Object value, DataType valueDataType, DataType expectedDataType) {
        return this.transformThrowingRuntimeException(() -> this.internalTransform(value, valueDataType, expectedDataType));
    }

    @Override
    public Message transform(Message message, DataType outputDataType) {
        return this.transformThrowingRuntimeException(() -> this.internalTransform(message, outputDataType));
    }

    private <T> T transformThrowingRuntimeException(CheckedSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }
}

