/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.inject.Inject;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class ObjectToString
extends AbstractTransformer
implements DiscoverableTransformer {
    private FeatureFlaggingService featureFlags;
    private int priorityWeighting = 2;

    public ObjectToString() {
        this.registerSourceType(DataType.OBJECT);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.setReturnDataType(DataType.STRING);
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        String output = src instanceof CursorStreamProvider ? this.createStringFromInputStream((InputStream)((CursorStreamProvider)src).openCursor(), outputEncoding) : (src instanceof CursorIteratorProvider ? (this.featureFlags.isEnabled(MuleRuntimeFeature.TO_STRING_TRANSFORMER_TRANSFORM_ITERATOR_ELEMENTS) ? this.createStringFromItearator((CursorIterator)((CursorIteratorProvider)src).openCursor(), outputEncoding) : StringMessageUtils.toString(src)) : (src instanceof Iterator ? "<<Non repeatable iterator>>" : (src instanceof InputStream ? this.createStringFromInputStream((InputStream)src, outputEncoding) : (src instanceof OutputHandler ? this.createStringFromOutputHandler((OutputHandler)src, outputEncoding) : (src instanceof byte[] ? this.createStringFromByteArray((byte[])src, outputEncoding) : StringMessageUtils.toString(src))))));
        return output;
    }

    protected String createStringFromInputStream(InputStream input, Charset outputEncoding) throws TransformerException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.copyLarge(input, outputStream);
            String string = outputStream.toString(outputEncoding.name());
            return string;
        }
        catch (IOException e) {
            throw new TransformerException(CoreMessages.errorReadingStream(), (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.warn("Could not close stream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createStringFromItearator(CursorIterator input, Charset outputEncoding) throws TransformerException {
        try {
            StringBuilder output = new StringBuilder();
            output.append("[");
            CursorIterator iterator = input;
            while (iterator.hasNext()) {
                Object item = iterator.next();
                output.append(this.transform(item, outputEncoding).toString());
                output.append(", ");
            }
            output.delete(output.length() - 2, output.length());
            output.append("]");
            String string = output.toString();
            return string;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.warn("Could not close stream", (Throwable)e);
            }
        }
    }

    protected String createStringFromOutputHandler(OutputHandler handler, Charset outputEncoding) throws TransformerException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            handler.write(PrivilegedEvent.getCurrentEvent(), bytes);
            return bytes.toString(outputEncoding.name());
        }
        catch (IOException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected String createStringFromByteArray(byte[] bytes, Charset outputEncoding) throws TransformerException {
        return new String(bytes, outputEncoding);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }

    @Inject
    public void setFeatureFlags(FeatureFlaggingService featureFlags) {
        this.featureFlags = featureFlags;
    }

    public static void configureToStringTransformerTransformIteratorElements() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.TO_STRING_TRANSFORMER_TRANSFORM_ITERATOR_ELEMENTS, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }
}

