/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;

class DefaultMethodRequestMatcher
implements MethodRequestMatcher {
    private final Collection<String> methods;

    DefaultMethodRequestMatcher(Collection<String> methods) {
        this.methods = methods;
    }

    @Override
    public boolean intersectsWith(MethodRequestMatcher matcher) {
        Preconditions.checkArgument(matcher != null, "matcher cannot be null");
        for (String method : this.methods) {
            if (!matcher.getMethods().contains(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        return this.methods.contains(httpRequest.getMethod().toUpperCase());
    }

    public String toString() {
        return "MethodRequestMatcher{methods=" + Arrays.toString(this.methods.toArray()) + '}';
    }

    @Override
    public List<String> getMethods() {
        return Collections.unmodifiableList(new ArrayList<String>(this.methods));
    }

    public int hashCode() {
        return 31 * this.methods.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultMethodRequestMatcher && Objects.equals(this.methods, ((DefaultMethodRequestMatcher)obj).methods);
    }
}

