/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.metadata.internal.DefaultMetadataResolverFactory;
import org.mule.runtime.metadata.internal.NullMetadataResolverFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SemanticTermsParser;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;

public final class ModelLoaderUtils {
    private ModelLoaderUtils() {
    }

    public static void addSemanticTerms(WithSemanticTermsDeclaration declaration, SemanticTermsParser parser) {
        declaration.getSemanticTerms().addAll(parser.getSemanticTerms());
    }

    public static XmlDslModel getXmlDslModel(String extensionName, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        Optional<String> prefix = Optional.empty();
        Optional<String> namespace = Optional.empty();
        if (xmlDslAnnotationConfiguration.isPresent()) {
            prefix = Optional.of(xmlDslAnnotationConfiguration.get().getPrefix());
            namespace = Optional.of(xmlDslAnnotationConfiguration.get().getNamespace());
        }
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, extensionName, version);
    }

    public static XmlDslModel getXmlDslModel(ExtensionElement extensionElement, String version, Optional<XmlDslConfiguration> xmlDslAnnotationConfiguration) {
        return ModelLoaderUtils.getXmlDslModel(extensionElement.getName(), version, xmlDslAnnotationConfiguration);
    }

    public static void declareTypeResolversInformationModelProperty(BaseDeclaration baseDeclaration, Optional<OutputResolverModelParser> outputResolverModelParser, Optional<AttributesResolverModelParser> attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser, boolean requiresConnection) {
        if (outputResolverModelParser.isPresent() && outputResolverModelParser.get().hasOutputResolver() || !inputResolverModelParsers.isEmpty()) {
            Map<String, String> inputResolversByParam = inputResolverModelParsers.stream().collect(Collectors.toImmutableMap(InputResolverModelParser::getParameterName, r -> r.getInputResolver().getResolverName()));
            String outputResolver = outputResolverModelParser.map(outputResolverParser -> outputResolverParser.getOutputResolver().getResolverName()).orElse("NullResolver");
            String attributesResolver = attributesResolverModelParser.map(attributesResolverParser -> attributesResolverParser.getAttributesResolver().getResolverName()).orElse("NullResolver");
            String keysResolver = keyIdResolverModelParser.map(keyResolverParser -> keyResolverParser.getKeyResolver().getResolverName()).orElse("NullResolver");
            boolean isPartialKeyResolver = keyIdResolverModelParser.map(MetadataKeyModelParser::isPartialKeyResolver).orElse(false);
            String categoryName = ModelLoaderUtils.getCategoryName(keyIdResolverModelParser.orElse(null), inputResolverModelParsers, outputResolverModelParser.orElse(null));
            TypeResolversInformationModelProperty typeResolversInformationModelProperty = new TypeResolversInformationModelProperty(categoryName, inputResolversByParam, outputResolver, attributesResolver, keysResolver, requiresConnection, requiresConnection, isPartialKeyResolver);
            baseDeclaration.addModelProperty(typeResolversInformationModelProperty);
        }
    }

    public static void declareMetadataResolverFactoryModelProperty(BaseDeclaration baseDeclaration, Optional<OutputResolverModelParser> outputResolverModelParser, Optional<AttributesResolverModelParser> attributesResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser) {
        MetadataResolverFactory metadataResolverFactory;
        if (outputResolverModelParser.isPresent() && outputResolverModelParser.get().hasOutputResolver() || !inputResolverModelParsers.isEmpty()) {
            NullMetadataResolver nullMetadataResolver = new NullMetadataResolver();
            OutputTypeResolver outputTypeResolver = outputResolverModelParser.map(OutputResolverModelParser::getOutputResolver).orElse(nullMetadataResolver);
            Supplier<OutputTypeResolver> outputTypeResolverSupplier = () -> outputTypeResolver;
            AttributesTypeResolver attributesTypeResolver = attributesResolverModelParser.map(AttributesResolverModelParser::getAttributesResolver).orElse(nullMetadataResolver);
            Supplier<AttributesTypeResolver> attributesTypeResolverSupplier = () -> attributesTypeResolver;
            TypeKeysResolver typeKeysResolver = keyIdResolverModelParser.map(MetadataKeyModelParser::getKeyResolver).orElse(nullMetadataResolver);
            Supplier<TypeKeysResolver> typeKeysResolverSupplier = () -> typeKeysResolver;
            HashMap<String, Supplier<? extends InputTypeResolver>> inputTypeResolvers = new HashMap<String, Supplier<? extends InputTypeResolver>>();
            inputResolverModelParsers.forEach(parser -> inputTypeResolvers.put(parser.getParameterName(), parser::getInputResolver));
            metadataResolverFactory = new DefaultMetadataResolverFactory(typeKeysResolverSupplier, inputTypeResolvers, outputTypeResolverSupplier, attributesTypeResolverSupplier);
        } else {
            metadataResolverFactory = new NullMetadataResolverFactory();
        }
        baseDeclaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> metadataResolverFactory));
    }

    public static String getCategoryName(MetadataKeyModelParser metadataKeyModelParser, List<InputResolverModelParser> inputResolverModelParsers, OutputResolverModelParser outputResolverModelParser) {
        if (metadataKeyModelParser != null && metadataKeyModelParser.hasKeyIdResolver()) {
            return metadataKeyModelParser.getKeyResolver().getCategoryName();
        }
        if (!inputResolverModelParsers.isEmpty()) {
            return inputResolverModelParsers.iterator().next().getInputResolver().getCategoryName();
        }
        if (outputResolverModelParser != null && outputResolverModelParser.hasOutputResolver()) {
            return outputResolverModelParser.getOutputResolver().getCategoryName();
        }
        return null;
    }

    public static void declareOperationMetadataKeyIdModelProperty(OperationDeclarer operation, Optional<OutputResolverModelParser> outputResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser) {
        ModelLoaderUtils.declareMetadateKeyIdModelProperty(operation, outputResolverModelParser, inputResolverModelParsers, keyIdResolverModelParser);
    }

    public static void declareSourceMetadataKeyIdModelProperty(SourceDeclarer source, Optional<OutputResolverModelParser> outputResolverModelParser, Optional<MetadataKeyModelParser> keyIdResolverModelParser) {
        ModelLoaderUtils.declareMetadateKeyIdModelProperty(source, outputResolverModelParser, Collections.emptyList(), keyIdResolverModelParser);
    }

    private static void declareMetadateKeyIdModelProperty(ComponentDeclarer declarer, Optional<OutputResolverModelParser> outputResolverModelParser, List<InputResolverModelParser> inputResolverModelParsers, Optional<MetadataKeyModelParser> keyIdResolverModelParser) {
        if (keyIdResolverModelParser.isPresent()) {
            String parameterName = keyIdResolverModelParser.get().getParameterName();
            MetadataType metadataType = keyIdResolverModelParser.get().getMetadataType();
            String categoryName = ModelLoaderUtils.getCategoryName(keyIdResolverModelParser.orElse(null), inputResolverModelParsers, outputResolverModelParser.orElse(null));
            declarer.withModelProperty(new MetadataKeyIdModelProperty(metadataType, parameterName, categoryName));
        }
    }
}

