/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.function.BiFunction;
import org.mule.runtime.api.util.ResourceLocator;

public class DefaultResourceLocator
implements ResourceLocator {
    private ResourceLoaderFormatter formatter = new ResourceLoaderFormatter();

    @Override
    public Optional<InputStream> load(String resource, Object caller) {
        return Optional.ofNullable(this.lookFrom((res, cl) -> cl.getResourceAsStream((String)res), resource, caller));
    }

    @Override
    public Optional<URL> find(String resource, Object caller) {
        return Optional.ofNullable(this.lookFrom((res, cl) -> cl.getResource((String)res), resource, caller));
    }

    @Override
    public Optional<InputStream> loadFrom(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type, Object caller) {
        return this.load(this.formatter.format(resource, groupId, artifactId, version, classifier, type), caller);
    }

    @Override
    public Optional<URL> findIn(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type, Object caller) {
        return this.find(this.formatter.format(resource, groupId, artifactId, version, classifier, type), caller);
    }

    private <T> T lookFrom(BiFunction<String, ClassLoader, T> action, String resource, Object caller) {
        T callingClassResult = action.apply(resource, caller.getClass().getClassLoader());
        if (callingClassResult == null) {
            return action.apply(resource, Thread.currentThread().getContextClassLoader());
        }
        return callingClassResult;
    }

    public static class ResourceLoaderFormatter {
        private static final String RESOURCE_FORMAT = "resource::%s:%s:%s:%s:%s:%s";

        public String format(String resource, String groupId, String artifactId, Optional<String> version, String classifier, String type) {
            return String.format(RESOURCE_FORMAT, groupId, artifactId, version.orElse(""), classifier, type, resource);
        }
    }
}

