/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.ast;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.artifact.activation.internal.ast.MuleSdkExtensionModelLoadingMediator;

public abstract class AbstractMuleSdkExtensionModelLoadingMediator
implements MuleSdkExtensionModelLoadingMediator {
    protected final Optional<ArtifactCoordinates> artifactCoordinates;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    protected AbstractMuleSdkExtensionModelLoadingMediator(Optional<ArtifactCoordinates> artifactCoordinates, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.artifactCoordinates = artifactCoordinates;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    @Override
    public Optional<ExtensionModel> loadExtensionModel(ArtifactAst ast, ClassLoader classLoader, Set<ExtensionModel> extensions) throws ConfigurationException {
        if (!this.containsReusableComponents(ast)) {
            return Optional.empty();
        }
        ExtensionModelLoader loader = this.getLoader();
        ExtensionModelLoadingRequest.Builder loadingRequestBuilder = ExtensionModelLoadingRequest.builder(classLoader, DslResolvingContext.getDefault(extensions)).addParameter("version", this.getVersion()).addParameter("muleSDK.artifactAst", ast).addParameter("muleSDK.expressionLanguageMetadataService", this.expressionLanguageMetadataService);
        this.artifactCoordinates.ifPresent(loadingRequestBuilder::setArtifactCoordinates);
        this.addCustomLoadingRequestParameters(loadingRequestBuilder);
        return Optional.of(loader.loadExtensionModel(loadingRequestBuilder.build()));
    }

    protected abstract String getVersion() throws ConfigurationException;

    protected abstract ExtensionModelLoader getLoader() throws ConfigurationException;

    protected void addCustomLoadingRequestParameters(ExtensionModelLoadingRequest.Builder loadingRequestBuilder) {
    }

    protected abstract boolean containsReusableComponents(ArtifactAst var1);
}

