/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader.type.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.annotation.Soap;
import org.mule.runtime.extension.api.soap.annotation.SoapMessageDispatcherProviders;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.MessageDispatcherProviderTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapComponentWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;

public class SoapExtensionTypeWrapper<T>
extends SoapComponentWrapper {
    private ClassTypeLoader typeLoader;

    public SoapExtensionTypeWrapper(Class<T> extensionType, ClassTypeLoader typeLoader) {
        super(extensionType, typeLoader);
        this.typeLoader = typeLoader;
    }

    public List<SoapServiceProviderWrapper> getSoapServiceProviders() {
        ImmutableList.Builder serviceProviders = ImmutableList.builder();
        if (this.isAssignableTo(SoapServiceProvider.class)) {
            serviceProviders.add((Object)new SoapServiceProviderWrapper((Class<? extends SoapServiceProvider>)this.getDeclaringClass().get(), this.typeLoader));
        }
        this.getValueFromAnnotation(Soap.class).ifPresent(soap -> soap.getClassArrayValue(Soap::value).stream().forEach(sp -> {
            Class<?> type = sp.getDeclaringClass().get();
            serviceProviders.add((Object)new SoapServiceProviderWrapper((Class<? extends SoapServiceProvider>)type, this.typeLoader));
        }));
        return serviceProviders.build();
    }

    public List<MessageDispatcherProviderTypeWrapper> getDispatcherProviders() {
        return this.getValueFromAnnotation(SoapMessageDispatcherProviders.class).map(value -> value.getClassArrayValue(SoapMessageDispatcherProviders::value).stream().map(type -> new MessageDispatcherProviderTypeWrapper(type.getDeclaringClass().get(), this.typeLoader)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

