/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.store.LazyObjectStoreToMapAdapter;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;

public class ClientCredentialsOAuthHandler
extends OAuthHandler<ClientCredentialsOAuthDancer> {
    public ClientCredentialsOAuthDancer register(ClientCredentialsConfig config) {
        return this.register(config, Collections.emptyList());
    }

    public ClientCredentialsOAuthDancer register(ClientCredentialsConfig config, List<ClientCredentialsListener> listeners) {
        return this.dancers.computeIfAbsent(config.getConfigIdentifier(), k -> this.createDancer(config, listeners));
    }

    public void refreshToken(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        try {
            dancer.refreshToken().get();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not refresh token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
        }
    }

    public ResourceOwnerOAuthContext getOAuthContext(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        if (dancer == null) {
            throw new IllegalStateException(String.format("Client Credentials dancer for config '%s' not yet registered", config.getOwnerConfigName()));
        }
        ResourceOwnerOAuthContext contextForResourceOwner = dancer.getContext();
        if (contextForResourceOwner == null || contextForResourceOwner.getAccessToken() == null) {
            try {
                dancer.accessToken().get();
                contextForResourceOwner = dancer.getContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not obtain access token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
            }
        }
        return contextForResourceOwner;
    }

    public void invalidate(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        if (dancer == null) {
            return;
        }
        dancer.invalidateContext();
    }

    private ClientCredentialsOAuthDancer createDancer(ClientCredentialsConfig config, List<ClientCredentialsListener> listeners) throws MuleException {
        Preconditions.checkArgument(listeners != null, "listeners cannot be null");
        OAuthClientCredentialsDancerBuilder dancerBuilder = ((OAuthService)this.oauthService.get()).clientCredentialsGrantTypeDancerBuilder(this.lockFactory, new LazyObjectStoreToMapAdapter(() -> this.objectStoreLocator.apply(config)), this.expressionEvaluator);
        ClientCredentialsGrantType grantType = config.getGrantType();
        dancerBuilder.name(config.getOwnerConfigName()).encoding(SystemUtils.getDefaultEncoding(this.muleContext)).clientCredentials(config.getClientId(), config.getClientSecret()).tokenUrl(config.getTokenUrl()).responseExpiresInExpr(grantType.getExpirationRegex()).responseAccessTokenExpr(grantType.getAccessTokenExpr()).withClientCredentialsIn(ExtensionsOAuthUtils.toCredentialsLocation(grantType.getCredentialsPlacement())).resourceOwnerIdTransformer(ownerId -> ownerId + "-" + config.getOwnerConfigName() + "-" + this.generateId(config));
        String scopes = config.getScope().orElseGet(() -> grantType.getDefaultScopes().orElse(null));
        if (scopes != null) {
            dancerBuilder.scopes(scopes);
        }
        dancerBuilder.customParameters(config.getCustomQueryParameters()).customHeaders(config.getCustomHeaders()).customBodyParameters(config.getCustomBodyParameters()).customParametersExtractorsExprs(this.getParameterExtractors(config));
        listeners.forEach(dancerBuilder::addListener);
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)dancerBuilder.build();
        if (this.started) {
            this.start(dancer);
        }
        return dancer;
    }

    private Integer generateId(ClientCredentialsConfig config) {
        return Objects.hash(config.getOwnerConfigName(), config.getClientId(), config.getClientSecret(), config.getTokenUrl(), config.getScope(), config.getCustomQueryParameters(), config.getCustomHeaders());
    }
}

