/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes;

import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.ExtensionConstants;

public final class InMemoryCursorStreamConfig {
    private final DataSize initialBufferSize;
    private final DataSize bufferSizeIncrement;
    private final DataSize maxBufferSize;
    private final boolean eagerRead;

    public static InMemoryCursorStreamConfig getDefault() {
        return InMemoryCursorStreamConfig.getDefault(false);
    }

    public static InMemoryCursorStreamConfig getDefault(boolean eagerRead) {
        return new InMemoryCursorStreamConfig(new DataSize(512, ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT), new DataSize(512, ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT), new DataSize(1024, ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT), eagerRead);
    }

    public InMemoryCursorStreamConfig(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxBufferSize) {
        this(initialBufferSize, bufferSizeIncrement, maxBufferSize, false);
    }

    public InMemoryCursorStreamConfig(DataSize initialBufferSize, DataSize bufferSizeIncrement, DataSize maxBufferSize, boolean eagerRead) {
        int initial = initialBufferSize.toBytes();
        Preconditions.checkArgument(initial > 0, "initialBufferSize must be greater than zero bytes");
        int increment = bufferSizeIncrement.toBytes();
        Preconditions.checkArgument(increment >= 0, "bufferSizeIncrement cannot be a negative byte size");
        int max = maxBufferSize.toBytes();
        if (max > 0) {
            Preconditions.checkArgument(initial <= max, "initialBufferSize cannot be bigger than the maxBufferSize");
            Preconditions.checkArgument(increment <= max, "bufferSizeIncrement cannot be bigger than the maxBufferSize");
            Preconditions.checkArgument(initial + increment <= max, "initialBufferSize + bufferSizeIncrement cannot be bigger than the maxBufferSize, otherwise the buffer will never be able to expand");
        }
        this.initialBufferSize = initialBufferSize;
        this.bufferSizeIncrement = bufferSizeIncrement;
        this.maxBufferSize = maxBufferSize;
        this.eagerRead = eagerRead;
    }

    public DataSize getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public DataSize getBufferSizeIncrement() {
        return this.bufferSizeIncrement;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public boolean isEagerRead() {
        return this.eagerRead;
    }
}

