/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.metadata.NullQueryMetadataResolver;

public final class DefaultMetadataResolverFactory
implements MetadataResolverFactory {
    private final OutputTypeResolver outputTypeResolver;
    private final AttributesTypeResolver attributesTypeResolver;
    private final Map<String, InputTypeResolver> inputResolvers = new HashMap<String, InputTypeResolver>();
    private final TypeKeysResolver keysResolver;

    public DefaultMetadataResolverFactory(Supplier<? extends TypeKeysResolver> keyResolver, Map<String, Supplier<? extends InputTypeResolver>> typeResolvers, Supplier<? extends OutputTypeResolver> outputResolver, Supplier<? extends AttributesTypeResolver> attributesResolver) {
        Preconditions.checkArgument(keyResolver != null, "MetadataKeyResolver type cannot be null");
        Preconditions.checkArgument(typeResolvers != null, "InputTypeResolvers cannot be null");
        Preconditions.checkArgument(outputResolver != null, "OutputTypeResolver type cannot be null");
        Preconditions.checkArgument(attributesResolver != null, "AttributesTypeResolver type cannot be null");
        typeResolvers.forEach((k, v) -> this.inputResolvers.put((String)k, (InputTypeResolver)v.get()));
        this.keysResolver = keyResolver.get();
        this.outputTypeResolver = outputResolver.get();
        this.attributesTypeResolver = attributesResolver.get();
        Preconditions.checkArgument(this.keysResolver != null, "MetadataKeyResolver type cannot be null");
        this.inputResolvers.values().forEach(resolver -> Preconditions.checkArgument(resolver != null, "Input Type Resolver cannot be null"));
        Preconditions.checkArgument(this.outputTypeResolver != null, "OutputTypeResolver type cannot be null");
        Preconditions.checkArgument(this.attributesTypeResolver != null, "AttributesTypeResolver type cannot be null");
    }

    @Override
    public TypeKeysResolver getKeyResolver() {
        return this.keysResolver;
    }

    @Override
    public <T> InputTypeResolver<T> getInputResolver(String parameterName) {
        return this.inputResolvers.getOrDefault(parameterName, new NullMetadataResolver());
    }

    @Override
    public Collection<InputTypeResolver> getInputResolvers() {
        return Collections.unmodifiableCollection(this.inputResolvers.values());
    }

    @Override
    public <T> OutputTypeResolver<T> getOutputResolver() {
        return this.outputTypeResolver;
    }

    @Override
    public <T> AttributesTypeResolver<T> getOutputAttributesResolver() {
        return this.attributesTypeResolver;
    }

    @Override
    public QueryEntityResolver getQueryEntityResolver() {
        return new NullQueryMetadataResolver();
    }
}

