/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader.model.utils;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.artifact.activation.internal.classloader.Classifier;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ArtifactUtils {
    private static final String PACKAGE_TYPE = "jar";
    private static final String PROVIDED = "provided";
    private static final URI EMPTY_RESOURCE = URI.create("");
    private static final String POM_TYPE = "pom";

    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        return new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), bundleDescriptor.getClassifier().orElse(null));
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static List<Artifact> toArtifacts(List<BundleDependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifact).collect(Collectors.toList());
    }

    public static List<Artifact> toApplicationModelArtifacts(List<BundleDependency> appDependencies) {
        List<Artifact> dependencies = ArtifactUtils.toArtifacts(appDependencies);
        dependencies.forEach(ArtifactUtils::updateScopeIfDomain);
        return dependencies;
    }

    public static List<Artifact> updatePackagesResources(List<Artifact> artifacts) {
        return artifacts.stream().map(ArtifactUtils::updatePackagesResources).collect(Collectors.toList());
    }

    public static Artifact updatePackagesResources(Artifact artifact) {
        if (Classifier.MULE_PLUGIN.equals(artifact.getArtifactCoordinates().getClassifier()) || artifact.getUri() == null || StringUtils.isBlank((CharSequence)artifact.getUri().getPath())) {
            return artifact;
        }
        JarInfo jarInfo = new FileJarExplorer(false).explore(artifact.getUri());
        artifact.setPackages(jarInfo.getPackages().toArray(new String[0]));
        artifact.setResources(jarInfo.getResources().toArray(new String[0]));
        return artifact;
    }

    public static List<Artifact> updateArtifactsSharedState(List<BundleDependency> appDependencies, List<Artifact> artifacts, MavenPomParser parser, List<String> activeProfiles) {
        parser.getSharedLibraries().forEach(shareLibrary -> ArtifactUtils.findAndExportSharedLibrary(shareLibrary.getGroupId(), shareLibrary.getArtifactId(), artifacts, appDependencies));
        return artifacts;
    }

    private static void findAndExportSharedLibrary(String sharedLibraryGroupId, String sharedLibraryArtifactId, List<Artifact> artifacts, List<BundleDependency> deployableDependencies) {
        deployableDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(sharedLibraryGroupId) && bundleDependency.getDescriptor().getArtifactId().equals(sharedLibraryArtifactId)).forEach(bundleDependency -> ArtifactUtils.setArtifactTransitiveDependenciesAsShared(artifacts, bundleDependency));
    }

    private static void setArtifactTransitiveDependenciesAsShared(List<Artifact> artifacts, BundleDependency bundleDependency) {
        ArtifactUtils.setArtifactAsShared(bundleDependency.getDescriptor().getGroupId(), bundleDependency.getDescriptor().getArtifactId(), artifacts);
        bundleDependency.getTransitiveDependencies().stream().forEach(transitiveDependency -> ArtifactUtils.setArtifactTransitiveDependenciesAsShared(artifacts, transitiveDependency));
    }

    private static void setArtifactAsShared(String sharedLibraryGroupId, String sharedLibraryArtifactId, List<Artifact> artifacts) {
        artifacts.stream().filter(artifact -> artifact.getArtifactCoordinates().getGroupId().equals(sharedLibraryGroupId) && artifact.getArtifactCoordinates().getArtifactId().equals(sharedLibraryArtifactId)).forEach(artifact -> artifact.setShared(true));
    }

    public static void updateScopeIfDomain(Artifact artifact) {
        String classifier = artifact.getArtifactCoordinates().getClassifier();
        if (StringUtils.equals((CharSequence)classifier, (CharSequence)Classifier.MULE_DOMAIN.toString())) {
            artifact.getArtifactCoordinates().setScope(PROVIDED);
            artifact.setUri(EMPTY_RESOURCE);
        }
    }

    public static ArtifactCoordinates getDeployableArtifactCoordinates(MavenPomParser parser, ApplicationGAVModel appGAVModel) {
        ArtifactCoordinates deployableCoordinates = ArtifactUtils.toArtifactCoordinates(ArtifactUtils.getPomProjectBundleDescriptor(appGAVModel));
        deployableCoordinates.setType(PACKAGE_TYPE);
        deployableCoordinates.setClassifier(parser.getModel().getPackaging());
        return deployableCoordinates;
    }

    public static BundleDescriptor getPomProjectBundleDescriptor(ApplicationGAVModel appGAVModel) {
        return ArtifactUtils.getBundleDescriptor(appGAVModel);
    }

    public static BundleDescriptor getBundleDescriptor(ApplicationGAVModel appGAVModel) {
        return new BundleDescriptor.Builder().setGroupId(appGAVModel.getGroupId()).setArtifactId(appGAVModel.getArtifactId()).setVersion(appGAVModel.getVersion()).setBaseVersion(appGAVModel.getVersion()).setType(POM_TYPE).build();
    }
}

