/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.event;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;

@NoImplement
public interface CoreEvent
extends Serializable,
Event {
    public static CoreEvent nullEvent() {
        return NullEventFactory.getNullEvent();
    }

    public SecurityContext getSecurityContext();

    @Deprecated
    public Optional<GroupCorrelation> getGroupCorrelation();

    public FlowCallStack getFlowCallStack();

    public static Builder builder(EventContext context) {
        return new DefaultEventBuilder((BaseEventContext)context);
    }

    public static Builder builder(CoreEvent event) {
        return new DefaultEventBuilder((InternalEvent)event);
    }

    public static Builder builder(EventContext context, CoreEvent event) {
        return new DefaultEventBuilder((BaseEventContext)context, (InternalEvent)event);
    }

    public static <T> T getVariableValueOrNull(String key, CoreEvent event) {
        if (event.getVariables().containsKey(key)) {
            return (T)event.getVariables().get(key).getValue();
        }
        return null;
    }

    @NoImplement
    public static interface Builder {
        public Builder message(Message var1);

        public Builder message(Function<EventContext, Message> var1);

        public Builder variables(Map<String, ?> var1);

        public Builder addVariable(String var1, Object var2);

        public Builder addVariable(String var1, Object var2, DataType var3);

        public Builder addVariable(String var1, TypedValue<?> var2);

        public Builder removeVariable(String var1);

        public Builder clearVariables();

        public Builder parameters(Map<String, ?> var1);

        public Builder clearParameters();

        @Deprecated
        public Builder groupCorrelation(Optional<GroupCorrelation> var1);

        default public Builder itemSequenceInfo(Optional<ItemSequenceInfo> itemSequenceInfo) {
            return this;
        }

        public Builder error(Error var1);

        public Builder securityContext(SecurityContext var1);

        public CoreEvent build();
    }
}

