/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.internal.ast.XmlSdkImplicitConfigParameter;

public class XmlSdkImplicitConfig
extends BaseComponentAst {
    public static final String IMPLICIT_CONFIG_NAME_SUFFIX = "%s-xml-sdk-implicit-config";
    private final ExtensionModel extensionModel;
    private final String configName;
    private final Set<ComponentParameterAst> componentParameterAsts = new HashSet<ComponentParameterAst>();

    public XmlSdkImplicitConfig(ExtensionModel extensionModel) {
        this.extensionModel = extensionModel;
        this.configName = String.format(IMPLICIT_CONFIG_NAME_SUFFIX, extensionModel.getName());
        List parameterModels = this.getModel(ParameterizedModel.class).map(ParameterizedModel::getParameterGroupModels).orElse(Collections.emptyList()).stream().filter(parameterGroupModel -> parameterGroupModel.getName().equals("General")).findFirst().map(ParameterGroupModel::getParameterModels).orElse(Collections.emptyList());
        for (ParameterModel parameterModel : parameterModels) {
            Object value = parameterModel.getName().equals("name") ? this.configName : parameterModel.getDefaultValue();
            this.componentParameterAsts.add(new XmlSdkImplicitConfigParameter(parameterModel, value));
        }
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return ComponentIdentifier.builder().namespaceUri(this.extensionModel.getXmlDslModel().getNamespace()).namespace(this.extensionModel.getXmlDslModel().getPrefix()).name(this.configName).build();
    }

    @Override
    public TypedComponentIdentifier.ComponentType getComponentType() {
        return TypedComponentIdentifier.ComponentType.CONFIG;
    }

    @Override
    public ComponentLocation getLocation() {
        return DefaultComponentLocation.from(this.configName);
    }

    @Override
    public ComponentMetadataAst getMetadata() {
        return ComponentMetadataAst.EMPTY_METADATA;
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return ComponentGenerationInformation.EMPTY_GENERATION_INFO;
    }

    @Override
    public Optional<String> getComponentId() {
        return Optional.of(this.configName);
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return Collections.emptyMap();
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    @Override
    public <M> Optional<M> getModel(Class<M> modelClass) {
        return this.extensionModel.getConfigurationModel("config").filter(modelClass::isInstance);
    }

    @Override
    public MetadataType getType() {
        return null;
    }

    @Override
    public Collection<ComponentParameterAst> getParameters() {
        return this.componentParameterAsts;
    }

    @Override
    public List<ComponentAst> directChildren() {
        return Collections.emptyList();
    }
}

