/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;

public class ContainerClassLoaderFilterFactory {
    private static final String EMPTY_PACKAGE = "";
    private static final char RESOURCE_SEPARATOR = '/';

    public ClassLoaderFilter create(Set<String> bootPackages, List<MuleContainerModule> muleModules) {
        return this.create(bootPackages, muleModules, Collections.emptySet());
    }

    public ClassLoaderFilter create(Set<String> bootPackages, List<MuleContainerModule> muleModules, Set<String> additionalResources) {
        Set<String> resources = this.getExportedResourcePaths(muleModules);
        resources.addAll(additionalResources);
        Set<String> packages = this.getModuleExportedPackages(muleModules);
        DefaultArtifactClassLoaderFilter artifactClassLoaderFilter = new DefaultArtifactClassLoaderFilter(packages, resources);
        return new ContainerClassLoaderFilter(artifactClassLoaderFilter, bootPackages);
    }

    private Set<String> getExportedResourcePaths(List<MuleContainerModule> muleModules) {
        HashSet<String> resources = new HashSet<String>();
        for (MuleContainerModule muleModule : muleModules) {
            resources.addAll(muleModule.getExportedPaths());
        }
        return resources;
    }

    private Set<String> getModuleExportedPackages(List<MuleContainerModule> muleModules) {
        HashSet<String> packages = new HashSet<String>();
        for (MuleContainerModule muleModule : muleModules) {
            packages.addAll(muleModule.getExportedPackages());
        }
        return packages;
    }

    private static class ContainerClassLoaderFilter
    implements ClassLoaderFilter {
        public static final String CLASS_PACKAGE_SPLIT_REGEX = "\\.";
        public static final String RESOURCE_PACKAGE_SPLIT_REGEX = "/";
        private final ClassLoaderFilter moduleClassLoaderFilter;
        private final Set<String> bootPackages;

        private ContainerClassLoaderFilter(ClassLoaderFilter moduleClassLoaderFilter, Set<String> bootPackages) {
            this.moduleClassLoaderFilter = moduleClassLoaderFilter;
            this.bootPackages = bootPackages;
        }

        @Override
        public boolean exportsClass(String name) {
            boolean exported = this.moduleClassLoaderFilter.exportsClass(name);
            if (!exported) {
                exported = this.isExportedBootPackage(name, CLASS_PACKAGE_SPLIT_REGEX);
            }
            return exported;
        }

        @Override
        public boolean exportsPackage(String name) {
            boolean exported = this.moduleClassLoaderFilter.exportsPackage(name);
            if (!exported) {
                exported = this.isExportedBootPackage(name, CLASS_PACKAGE_SPLIT_REGEX);
            }
            return exported;
        }

        @Override
        public boolean exportsResource(String name) {
            String resourceFolder;
            boolean exported = this.moduleClassLoaderFilter.exportsResource(name);
            if (!exported && !(exported = this.moduleClassLoaderFilter.exportsResource(resourceFolder = this.getResourceFolder(name)))) {
                exported = this.isExportedBootPackage(name, RESOURCE_PACKAGE_SPLIT_REGEX);
            }
            return exported;
        }

        private String getResourceFolder(String resourceName) {
            String resourceFolder = ContainerClassLoaderFilterFactory.EMPTY_PACKAGE;
            if (resourceName.length() > 0) {
                resourceFolder = resourceName.charAt(0) == '/' ? resourceName.substring(1) : resourceName;
                resourceFolder = resourceFolder.lastIndexOf(47) < 0 ? ContainerClassLoaderFilterFactory.EMPTY_PACKAGE : resourceFolder.substring(0, resourceFolder.lastIndexOf(47));
            }
            return resourceFolder;
        }

        private boolean isExportedBootPackage(String name, String splitRegex) {
            boolean exported = false;
            String[] splitName = name.split(splitRegex);
            String[] packages = Arrays.copyOf(splitName, splitName.length - 1);
            String candidatePackage = ContainerClassLoaderFilterFactory.EMPTY_PACKAGE;
            for (String currentPackage : packages) {
                if (candidatePackage.length() != 0) {
                    candidatePackage = candidatePackage + ".";
                }
                if (!this.bootPackages.contains(candidatePackage = candidatePackage + currentPackage)) continue;
                exported = true;
                break;
            }
            return exported;
        }

        public String toString() {
            return this.getClass().getName() + "[\n  moduleClassLoaderFilter=" + this.moduleClassLoaderFilter + ",\n  bootPackages=" + this.bootPackages + ",\n]";
        }
    }
}

