/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonDeserializingArtifactModelResolver<M extends MuleDeployableModel>
implements ArtifactModelResolver<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDeserializingArtifactModelResolver.class);
    private final AbstractMuleArtifactModelJsonSerializer<M> jsonDeserializer;

    public JsonDeserializingArtifactModelResolver(AbstractMuleArtifactModelJsonSerializer<M> jsonDeserializer) {
        this.jsonDeserializer = jsonDeserializer;
    }

    @Override
    public M resolve(File artifactLocation) {
        File artifactJsonFile = new File(artifactLocation, "mule-artifact.json");
        if (!artifactJsonFile.exists()) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage("Couldn't find model file " + artifactJsonFile));
        }
        return this.loadModelFromJson(this.getDescriptorContent(artifactJsonFile));
    }

    private String getDescriptorContent(File jsonFile) {
        String string;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading artifact descriptor from '{}'..." + jsonFile.getAbsolutePath());
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(jsonFile));
        try {
            string = IOUtils.toString(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read extension describer on artifact '%s'", jsonFile.getAbsolutePath()), e);
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    private M loadModelFromJson(String jsonString) {
        try {
            return this.deserializeArtifactModel(jsonString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot deserialize artifact descriptor from: " + jsonString);
        }
    }

    private M deserializeArtifactModel(String jsonString) throws IOException {
        return (M)((MuleDeployableModel)this.getMuleArtifactModelJsonSerializer().deserialize(jsonString));
    }

    private AbstractMuleArtifactModelJsonSerializer<M> getMuleArtifactModelJsonSerializer() {
        return this.jsonDeserializer;
    }
}

