/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.VersionUtils;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class DeployablePluginsDependenciesResolver {
    public final Map<ArtifactCoordinates, List<Artifact>> resolve(List<BundleDependency> deployableDependencies) {
        HashMap<ArtifactCoordinates, List<Artifact>> pluginsDependencies = new HashMap<ArtifactCoordinates, List<Artifact>>();
        List<BundleDependency> dependencies = deployableDependencies.stream().filter(dep -> dep.getDescriptor().getClassifier().isPresent()).filter(dep -> dep.getDescriptor().getClassifier().get().equals("mule-plugin")).collect(Collectors.toList());
        Map<BundleDependency, List<BundleDependency>> dependenciesMap = this.resolveDependencies(dependencies);
        for (Map.Entry<BundleDependency, List<BundleDependency>> dependencyListEntry : dependenciesMap.entrySet()) {
            List<BundleDependency> dependencyDependencies = this.resolveConflicts(dependencyListEntry.getValue(), dependencies);
            pluginsDependencies.put(ArtifactUtils.toArtifactCoordinates(dependencyListEntry.getKey().getDescriptor()), ArtifactUtils.updatePackagesResources(ArtifactUtils.toArtifacts(dependencyDependencies)));
        }
        return pluginsDependencies;
    }

    private List<BundleDependency> resolveConflicts(List<BundleDependency> newDependencies, List<BundleDependency> alreadyResolved) {
        return this.resolveMulePluginsVersions(newDependencies, alreadyResolved);
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> mulePlugins) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> muleDependenciesDependencies = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency muleDependency : mulePlugins) {
            muleDependenciesDependencies.put(muleDependency, this.collectTransitiveDependencies(muleDependency));
        }
        return muleDependenciesDependencies;
    }

    private List<BundleDependency> collectTransitiveDependencies(BundleDependency rootDependency) {
        LinkedList<BundleDependency> allTransitiveDependencies = new LinkedList<BundleDependency>();
        for (BundleDependency transitiveDependency : rootDependency.getTransitiveDependencies()) {
            allTransitiveDependencies.add(transitiveDependency);
            if (!transitiveDependency.getDescriptor().getClassifier().map(c -> !"mule-plugin".equals(c)).orElse(true).booleanValue()) continue;
            allTransitiveDependencies.addAll(this.collectTransitiveDependencies(transitiveDependency));
        }
        return allTransitiveDependencies;
    }

    protected List<BundleDependency> resolveMulePluginsVersions(List<BundleDependency> mulePluginsToResolve, List<BundleDependency> definitiveMulePlugins) {
        ArrayList<BundleDependency> resolvedPlugins = new ArrayList<BundleDependency>();
        Preconditions.checkArgument(mulePluginsToResolve != null, "List of mule plugins to resolve should not be null");
        Preconditions.checkArgument(definitiveMulePlugins != null, "List of definitive mule plugins should not be null");
        for (BundleDependency mulePluginToResolve : mulePluginsToResolve) {
            Optional<BundleDependency> mulePlugin = definitiveMulePlugins.stream().filter(p -> this.hasSameArtifactIdAndMajor((BundleDependency)p, mulePluginToResolve)).findFirst();
            resolvedPlugins.add(mulePlugin.orElse(mulePluginToResolve));
        }
        return resolvedPlugins;
    }

    protected boolean hasSameArtifactIdAndMajor(BundleDependency bundleDependency, BundleDependency otherBundleDependency) {
        BundleDescriptor descriptor = bundleDependency.getDescriptor();
        BundleDescriptor otherDescriptor = otherBundleDependency.getDescriptor();
        return StringUtils.equals((CharSequence)descriptor.getArtifactId(), (CharSequence)otherDescriptor.getArtifactId()) && StringUtils.equals((CharSequence)VersionUtils.getMajor(descriptor.getBaseVersion()), (CharSequence)VersionUtils.getMajor(otherDescriptor.getBaseVersion()));
    }
}

