/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import org.apache.logging.log4j.core.selector.ContextSelector;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.log4j.boot.api.MuleLog4jContextFactory;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.SimpleContextSelector;

public final class MuleLog4jConfiguratorUtils {
    private MuleLog4jConfiguratorUtils() {
    }

    public static void configureSelector(MuleLog4jContextFactory contextFactory) {
        MuleLog4jConfiguratorUtils.configureSelector(contextFactory, System.getProperty("mule.disableLogSeparation") == null);
    }

    public static void configureSelector(MuleLog4jContextFactory contextFactory, boolean logSeparationEnabled) {
        if (logSeparationEnabled) {
            contextFactory.setContextSelector(new ArtifactAwareContextSelector(), MuleLog4jConfiguratorUtils::disposeIfDisposable);
        } else {
            contextFactory.setContextSelector(new SimpleContextSelector(), MuleLog4jConfiguratorUtils::disposeIfDisposable);
        }
    }

    private static void disposeIfDisposable(ContextSelector selector) {
        if (selector instanceof Disposable) {
            ((Disposable)selector).dispose();
        }
    }
}

