/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class SchedulersStateOperation
implements TroubleshootingOperation {
    public static final String SCHEDULERS_STATE_OPERATION_NAME = "schedulers";
    public static final String SCHEDULERS_STATE_OPERATION_DESCRIPTION = "Shows the state of currently available schedulers";
    private final Supplier<Optional<SchedulerService>> schedulerService = () -> serviceRepository.getServices().stream().filter(SchedulerService.class::isInstance).map(SchedulerService.class::cast).findFirst();

    public SchedulersStateOperation(ServiceRepository serviceRepository) {
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            Optional<SchedulerService> foundSchedulerService = this.schedulerService.get();
            if (!foundSchedulerService.isPresent()) {
                return;
            }
            TreeSet<SchedulerView> schedulers = new TreeSet<SchedulerView>((s1, s2) -> s1.getName().compareTo(s2.getName()));
            schedulers.addAll(foundSchedulerService.get().getSchedulers());
            for (SchedulerView schedulerView : schedulers) {
                this.writeScheduler(writer, schedulerView);
                writer.write(System.lineSeparator());
            }
        };
    }

    private void writeScheduler(Writer writer, SchedulerView schedulerView) throws IOException {
        TimedDataAggregation<Integer> throttlesOverTime;
        TimedDataAggregation<Integer> rejectionsOverTime;
        writer.write(String.format("\"%s\" (%s)%n", schedulerView.getName(), schedulerView.getThreadType()));
        if (schedulerView.isShutdown() || schedulerView.isTerminated()) {
            writer.write(String.format("  Shutdown: %b - Terminated: %b%n", schedulerView.isShutdown(), schedulerView.isTerminated()));
        }
        writer.write(String.format("  Active tasks: %d%n", schedulerView.getActiveTasks()));
        if (schedulerView.getQueuedTasks() > 0) {
            writer.write(String.format("  Queued tasks: %d%n", schedulerView.getQueuedTasks()));
        }
        if ((rejectionsOverTime = schedulerView.getRejectionsOverTime()).forLast60MinsInterval() > 0) {
            writer.write(String.format("   Rejections: %3d / %3d / %4d / %4d%n", rejectionsOverTime.forLast1MinInterval(), rejectionsOverTime.forLast5MinsInterval(), rejectionsOverTime.forLast15MinsInterval(), rejectionsOverTime.forLast60MinsInterval()));
        }
        if ((throttlesOverTime = schedulerView.getThrottlesOverTime()).forLast60MinsInterval() > 0) {
            writer.write(String.format("   Throttles:  %3d / %3d / %4d / %4d%n", throttlesOverTime.forLast1MinInterval(), throttlesOverTime.forLast5MinsInterval(), throttlesOverTime.forLast15MinsInterval(), throttlesOverTime.forLast60MinsInterval()));
        }
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return new DefaultTroubleshootingOperationDefinition(SCHEDULERS_STATE_OPERATION_NAME, SCHEDULERS_STATE_OPERATION_DESCRIPTION, new ArgumentDefinition[0]);
    }
}

