/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployablePluginsDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.DeployableDependencyResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenUtilsForArtifact;
import org.mule.runtime.module.artifact.activation.internal.maven.MuleSystemPluginMavenReactorResolver;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenDeployableProjectModelBuilder
extends AbstractDeployableProjectModelBuilder {
    protected final MavenConfiguration mavenConfiguration;
    protected final File projectFolder;
    protected List<org.mule.maven.pom.parser.api.model.BundleDependency> deployableMavenBundleDependencies;
    protected List<BundleDependency> deployableBundleDependencies;
    protected Map<ArtifactCoordinates, List<Artifact>> pluginsArtifactDependencies;
    protected Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> sharedDeployableBundleDescriptors;
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> additionalPluginDependencies;
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> pluginsBundleDependencies;
    protected File deployableArtifactRepositoryFolder;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMavenDeployableProjectModelBuilder.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{\\s*([^}]*)\\s*\\}");

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider(MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier<File> localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional<File> globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional<File> userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional<File> settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation(localMavenRepository.get());
        globalSettings.ifPresent(mavenConfigurationBuilder::globalSettingsLocation);
        userSettings.ifPresent(mavenConfigurationBuilder::userSettingsLocation);
        settingsSecurity.ifPresent(mavenConfigurationBuilder::settingsSecurityLocation);
        return mavenConfigurationBuilder.build();
    }

    protected AbstractMavenDeployableProjectModelBuilder(MavenConfiguration mavenConfiguration, File projectFolder) {
        this.mavenConfiguration = mavenConfiguration;
        this.projectFolder = projectFolder;
    }

    @Override
    public final DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Optional<Object> version = Optional.empty();
        if (this.projectFolder.equals((Object)ArtifactType.APP) || this.projectFolder.equals((Object)ArtifactType.DOMAIN) || this.projectFolder.isDirectory()) {
            try {
                Properties pomProperties = MavenUtilsForArtifact.getPomPropertiesFolder(this.projectFolder);
                version = Optional.ofNullable(pomProperties.getProperty("version"));
            }
            catch (ArtifactDescriptorCreateException e) {
                logger.debug("unable to get version info from pom.properties:" + e.getMessage());
            }
        }
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        MavenPomParser parser = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(pom.toPath(), activeProfiles);
        String originalPomVersion = this.getVersion(parser);
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(originalPomVersion);
        if (matcher.find()) {
            String potentialProperty = matcher.group(1);
            if (System.getProperty(potentialProperty) != null) {
                version = Optional.ofNullable(matcher.replaceAll(System.getProperty(potentialProperty)));
            } else if (parser.getProperties().containsKey(potentialProperty)) {
                version = Optional.ofNullable(matcher.replaceAll(parser.getProperties().getProperty(potentialProperty)));
            }
        }
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(parser);
        try (MavenClient mavenClient = MavenClientFactory.createMavenClient(this.mavenConfiguration);){
            this.resolveDeployableDependencies(mavenClient, pom, parser, activeProfiles);
            this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
            this.resolveAdditionalPluginDependencies(mavenClient, parser, this.pluginsArtifactDependencies);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Error while resolving dependencies"), (Throwable)e);
        }
        if (version.isPresent()) {
            deployableArtifactCoordinates.setVersion((String)version.get());
        }
        return this.doBuild(parser, deployableArtifactCoordinates);
    }

    protected abstract DeployableProjectModel doBuild(MavenPomParser var1, ArtifactCoordinates var2);

    protected abstract File getPomFromFolder(File var1);

    protected abstract boolean isIncludeTestDependencies();

    protected final List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        List<String> attributeObject = attributes.getOrDefault(attribute, Collections.emptyList());
        Preconditions.checkArgument(attributeObject instanceof List, String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    protected final <T> T getSimpleAttribute(Map<String, Object> attributes, String attribute, T defaultValue) {
        return (T)attributes.getOrDefault(attribute, defaultValue);
    }

    protected org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(artifactCoordinates.getClassifier()).build();
    }

    private String getGroupId(MavenPomParser parser) {
        String groupId = parser.getModel().getGroupId();
        if (groupId == null && (groupId = parser.getModel().getParent().map(PomParentCoordinates::getGroupId).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failed to retrieve groupId from the artifact, trying to retrieve from parent POM but parent POM is not present")))) == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("GroupId is null in both current and parent POM"));
        }
        return groupId;
    }

    private String getArtifactId(MavenPomParser parser) {
        String artifactId = parser.getModel().getArtifactId();
        if (artifactId == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("ArtifactId is null in the POM"));
        }
        return artifactId;
    }

    private String getVersion(MavenPomParser parser) {
        String version = parser.getModel().getVersion();
        if (version == null && (version = parser.getModel().getParent().map(PomParentCoordinates::getVersion).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failed to retrieve version from the artifact, trying to retrieve from parent POM but parent POM is not present")))) == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Version is null in both current and parent POM"));
        }
        return version;
    }

    private ArtifactCoordinates getDeployableProjectArtifactCoordinates(MavenPomParser parser) {
        ApplicationGAVModel deployableGAVModel = new ApplicationGAVModel(this.getGroupId(parser), this.getArtifactId(parser), this.getVersion(parser));
        return ArtifactUtils.getDeployableArtifactCoordinates(parser, deployableGAVModel);
    }

    private void resolveDeployableDependencies(MavenClient mavenClient, File pom, MavenPomParser parser, List<String> activeProfiles) {
        DeployableDependencyResolver deployableDependencyResolver = new DeployableDependencyResolver(mavenClient);
        this.deployableMavenBundleDependencies = deployableDependencyResolver.resolveDeployableDependencies(pom, this.isIncludeTestDependencies(), this.getMavenReactorResolver());
        this.deployableMavenBundleDependencies = this.resolveSystemScopeDependencies(mavenClient, this.deployableMavenBundleDependencies);
        List<Artifact> deployableArtifactDependencies = ArtifactUtils.updateArtifactsSharedState(this.deployableMavenBundleDependencies, ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts(this.deployableMavenBundleDependencies)), parser, activeProfiles);
        this.deployableBundleDependencies = deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        this.sharedDeployableBundleDescriptors = this.deployableBundleDependencies.stream().filter(bd -> deployableArtifactDependencies.stream().anyMatch(artifact -> artifact.isShared() && bd.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bd.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId()))).map(BundleDependency::getDescriptor).collect(Collectors.toSet());
    }

    protected Optional<MavenReactorResolver> getMavenReactorResolver() {
        return Optional.empty();
    }

    private List<org.mule.maven.pom.parser.api.model.BundleDependency> resolveSystemScopeDependencies(MavenClient mavenClient, List<org.mule.maven.pom.parser.api.model.BundleDependency> deployableMavenBundleDependencies) {
        ArrayList systemScopeDependenciesTransitiveDependencies = new ArrayList();
        List<org.mule.maven.pom.parser.api.model.BundleDependency> result = deployableMavenBundleDependencies.stream().map(bundleDependency -> {
            if ("mule-plugin".equals(bundleDependency.getDescriptor().getClassifier().orElse(null)) && BundleScope.SYSTEM.equals((Object)bundleDependency.getScope())) {
                try (MuleSystemPluginMavenReactorResolver reactor = new MuleSystemPluginMavenReactorResolver(new File(bundleDependency.getBundleUri()), mavenClient);){
                    org.mule.maven.pom.parser.api.model.BundleDependency systemScopeDependency = mavenClient.resolveArtifactDependencies(Collections.singletonList(bundleDependency.getDescriptor()), Optional.of(this.deployableArtifactRepositoryFolder), Optional.of(reactor)).get(0);
                    systemScopeDependenciesTransitiveDependencies.addAll(this.collectTransitivePluginDependencies(systemScopeDependency));
                    org.mule.maven.pom.parser.api.model.BundleDependency bundleDependency2 = systemScopeDependency;
                    return bundleDependency2;
                }
            }
            return bundleDependency;
        }).collect(Collectors.toList());
        result.addAll(systemScopeDependenciesTransitiveDependencies);
        return this.getUniqueDependencies(result);
    }

    private List<org.mule.maven.pom.parser.api.model.BundleDependency> getUniqueDependencies(List<org.mule.maven.pom.parser.api.model.BundleDependency> dependencies) {
        HashSet uniqueDependenciesIds = new HashSet();
        return dependencies.stream().filter(dependency -> {
            BundleDescriptor descriptor = dependency.getDescriptor();
            String pluginKey = descriptor.getGroupId() + ":" + descriptor.getArtifactId() + ":" + descriptor.getVersion() + descriptor.getClassifier().map(classifier -> ":" + classifier).orElse("");
            boolean isApi = descriptor.getClassifier().map(ArtifactConstants.getApiClassifiers()::contains).orElse(false);
            boolean keep = !uniqueDependenciesIds.contains(pluginKey) || isApi;
            uniqueDependenciesIds.add(pluginKey);
            return keep;
        }).collect(Collectors.toList());
    }

    private List<org.mule.maven.pom.parser.api.model.BundleDependency> collectTransitivePluginDependencies(org.mule.maven.pom.parser.api.model.BundleDependency rootDependency) {
        ArrayList<org.mule.maven.pom.parser.api.model.BundleDependency> allTransitivePluginDependencies = new ArrayList<org.mule.maven.pom.parser.api.model.BundleDependency>();
        for (org.mule.maven.pom.parser.api.model.BundleDependency transitiveDependency : rootDependency.getTransitiveDependencies()) {
            if (!transitiveDependency.getDescriptor().getClassifier().map("mule-plugin"::equals).orElse(false).booleanValue()) continue;
            allTransitivePluginDependencies.add(transitiveDependency);
            allTransitivePluginDependencies.addAll(this.collectTransitivePluginDependencies(transitiveDependency));
        }
        return allTransitivePluginDependencies;
    }

    private void resolveAdditionalPluginDependencies(MavenClient mavenClient, MavenPomParser parser, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        Map<org.mule.maven.pom.parser.api.model.ArtifactCoordinates, AdditionalPluginDependencies> initialAdditionalPluginDependencies = parser.getPomAdditionalPluginDependenciesForArtifacts();
        AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver = this.getAdditionalPluginDependenciesResolver(mavenClient, new LinkedList<AdditionalPluginDependencies>(initialAdditionalPluginDependencies.values()));
        this.additionalPluginDependencies = this.toPluginDependencies(additionalPluginDependenciesResolver.resolveDependencies(this.deployableMavenBundleDependencies, pluginsDependencies));
    }

    protected AdditionalPluginDependenciesResolver getAdditionalPluginDependenciesResolver(MavenClient mavenClient, List<AdditionalPluginDependencies> initialAdditionalPluginDependencies) {
        return new AdditionalPluginDependenciesResolver(mavenClient, initialAdditionalPluginDependencies, new File("temp"));
    }

    private void resolveDeployablePluginsData(List<org.mule.maven.pom.parser.api.model.BundleDependency> deployableMavenBundleDependencies) {
        this.pluginsArtifactDependencies = new DeployablePluginsDependenciesResolver().resolve(deployableMavenBundleDependencies);
        HashMap pluginsBundleDescriptors = new HashMap();
        this.pluginsArtifactDependencies.keySet().forEach(pluginArtifactCoordinates -> pluginsBundleDescriptors.put(pluginArtifactCoordinates, this.buildBundleDescriptor((ArtifactCoordinates)pluginArtifactCoordinates)));
        this.pluginsBundleDependencies = new HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>>();
        this.pluginsArtifactDependencies.forEach((pluginArtifactCoordinates, pluginDependencies) -> this.pluginsBundleDependencies.put((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginsBundleDescriptors.get(pluginArtifactCoordinates), pluginDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList())));
        this.deployableBundleDependencies = this.deployableBundleDependencies.stream().map(dbd -> new BundleDependency.Builder((BundleDependency)dbd).setTransitiveDependencies(this.pluginsBundleDependencies.get(dbd.getDescriptor())).build()).collect(Collectors.toList());
    }

    private Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> toPluginDependencies(Map<org.mule.maven.pom.parser.api.model.BundleDependency, List<org.mule.maven.pom.parser.api.model.BundleDependency>> pluginsAndDependencies) {
        return pluginsAndDependencies.entrySet().stream().collect(Collectors.toMap(entry -> this.deployableBundleDependencies.stream().filter(bd -> bd.getDescriptor().getGroupId().equals(((org.mule.maven.pom.parser.api.model.BundleDependency)entry.getKey()).getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(((org.mule.maven.pom.parser.api.model.BundleDependency)entry.getKey()).getDescriptor().getArtifactId())).map(BundleDependency::getDescriptor).findAny().get(), entry -> {
            List<Artifact> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts((List)entry.getValue()));
            return deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        }));
    }

    private Function<Artifact, BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).setPackages(d.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getPackages())).setResources(d.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getResources())).build();
        };
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }
}

