/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.security.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.mule.runtime.core.privileged.security.tls.TlsConfiguration;

public class RestrictedSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sslSocketFactory;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final String[] defaultCipherSuites;
    private static RestrictedSSLSocketFactory defaultSocketFactory = null;

    public RestrictedSSLSocketFactory(SSLContext sslContext, String[] cipherSuites, String[] protocols) {
        this.sslSocketFactory = sslContext.getSocketFactory();
        if (cipherSuites == null) {
            cipherSuites = this.sslSocketFactory.getDefaultCipherSuites();
        }
        this.enabledCipherSuites = ArrayUtils.intersection(cipherSuites, this.sslSocketFactory.getSupportedCipherSuites());
        this.defaultCipherSuites = ArrayUtils.intersection(cipherSuites, this.sslSocketFactory.getDefaultCipherSuites());
        if (protocols == null) {
            protocols = sslContext.getDefaultSSLParameters().getProtocols();
        }
        this.enabledProtocols = ArrayUtils.intersection(protocols, sslContext.getSupportedSSLParameters().getProtocols());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket(host, port, clientAddress, clientPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket(address, port, clientAddress, clientPort));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.restrictCipherSuites((SSLSocket)this.sslSocketFactory.createSocket());
    }

    private SSLSocket restrictCipherSuites(SSLSocket socket) {
        socket.setEnabledCipherSuites(this.enabledCipherSuites);
        socket.setEnabledProtocols(this.enabledProtocols);
        return socket;
    }

    public static synchronized SocketFactory getDefault() {
        if (defaultSocketFactory == null) {
            try {
                TlsConfiguration configuration = new TlsConfiguration(null);
                configuration.initialise(true, null);
                defaultSocketFactory = new RestrictedSSLSocketFactory(configuration.getSslContext(), configuration.getEnabledCipherSuites(), configuration.getEnabledProtocols());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create the default RestrictedSSLSocketFactory"), (Throwable)e);
            }
        }
        return defaultSocketFactory;
    }
}

