/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerClassLoaderCreatorUtils;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class DefaultPreFilteredContainerClassLoaderCreator
implements PreFilteredContainerClassLoaderCreator {
    private final ModuleRepository moduleRepository;
    private Set<String> bootPackages = Collections.emptySet();
    private Set<String> resourceDirs = Collections.emptySet();

    public DefaultPreFilteredContainerClassLoaderCreator(ModuleRepository moduleRepository) {
        Preconditions.checkArgument(moduleRepository != null, "moduleRepository cannot be null");
        this.moduleRepository = moduleRepository;
    }

    public DefaultPreFilteredContainerClassLoaderCreator(ModuleRepository moduleRepository, Set<String> bootPackages, Set<String> additionalExportedResourceDirectories) {
        this(moduleRepository);
        this.bootPackages = bootPackages;
        this.resourceDirs = additionalExportedResourceDirectories;
    }

    @Override
    public List<MuleContainerModule> getMuleModules() {
        return this.moduleRepository.getModules();
    }

    @Override
    public Set<String> getBootPackages() {
        if (this.bootPackages.isEmpty()) {
            return BOOT_PACKAGES;
        }
        HashSet<String> finalBootPackages = new HashSet<String>();
        finalBootPackages.addAll(BOOT_PACKAGES);
        finalBootPackages.addAll(this.bootPackages);
        return finalBootPackages;
    }

    @Override
    public Set<String> getAdditionalExportedResourceDirectories() {
        return this.resourceDirs;
    }

    @Override
    public ArtifactClassLoader getPreFilteredContainerClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader) {
        return new MuleContainerClassLoader(artifactDescriptor, new URL[0], parentClassLoader, ContainerClassLoaderCreatorUtils.getLookupPolicy(parentClassLoader, this.getMuleModules(), this.getBootPackages()));
    }

    private static final class MuleContainerClassLoader
    extends MuleArtifactClassLoader {
        private MuleContainerClassLoader(ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super("container", artifactDescriptor, urls, parent, lookupPolicy);
        }

        @Override
        public URL findResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return Collections.emptyEnumeration();
        }

        static {
            MuleContainerClassLoader.registerAsParallelCapable();
        }
    }
}

